package io.fabric8.openshift.api.model.installer.openstack.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PlatformFluentImpl<A extends PlatformFluent<A>> extends BaseFluent<A> implements PlatformFluent<A>{
  public PlatformFluentImpl() {
  }
  public PlatformFluentImpl(Platform instance) {
    this.withApiFloatingIP(instance.getApiFloatingIP()); 
    this.withApiVIP(instance.getApiVIP()); 
    this.withCloud(instance.getCloud()); 
    this.withClusterOSImage(instance.getClusterOSImage()); 
    this.withClusterOSImageProperties(instance.getClusterOSImageProperties()); 
    this.withComputeFlavor(instance.getComputeFlavor()); 
    this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform()); 
    this.withExternalDNS(instance.getExternalDNS()); 
    this.withExternalNetwork(instance.getExternalNetwork()); 
    this.withIngressFloatingIP(instance.getIngressFloatingIP()); 
    this.withIngressVIP(instance.getIngressVIP()); 
    this.withLbFloatingIP(instance.getLbFloatingIP()); 
    this.withMachinesSubnet(instance.getMachinesSubnet()); 
    this.withOctaviaSupport(instance.getOctaviaSupport()); 
    this.withRegion(instance.getRegion()); 
    this.withTrunkSupport(instance.getTrunkSupport()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String apiFloatingIP;
  private String apiVIP;
  private String cloud;
  private String clusterOSImage;
  private Map<String,String> clusterOSImageProperties;
  private String computeFlavor;
  private MachinePoolBuilder defaultMachinePlatform;
  private List<String> externalDNS = new ArrayList<String>();
  private String externalNetwork;
  private String ingressFloatingIP;
  private String ingressVIP;
  private String lbFloatingIP;
  private String machinesSubnet;
  private String octaviaSupport;
  private String region;
  private String trunkSupport;
  private Map<String,Object> additionalProperties;
  public String getApiFloatingIP() {
    return this.apiFloatingIP;
  }
  public A withApiFloatingIP(String apiFloatingIP) {
    this.apiFloatingIP=apiFloatingIP; return (A) this;
  }
  public Boolean hasApiFloatingIP() {
    return this.apiFloatingIP != null;
  }
  public String getApiVIP() {
    return this.apiVIP;
  }
  public A withApiVIP(String apiVIP) {
    this.apiVIP=apiVIP; return (A) this;
  }
  public Boolean hasApiVIP() {
    return this.apiVIP != null;
  }
  public String getCloud() {
    return this.cloud;
  }
  public A withCloud(String cloud) {
    this.cloud=cloud; return (A) this;
  }
  public Boolean hasCloud() {
    return this.cloud != null;
  }
  public String getClusterOSImage() {
    return this.clusterOSImage;
  }
  public A withClusterOSImage(String clusterOSImage) {
    this.clusterOSImage=clusterOSImage; return (A) this;
  }
  public Boolean hasClusterOSImage() {
    return this.clusterOSImage != null;
  }
  public A addToClusterOSImageProperties(String key,String value) {
    if(this.clusterOSImageProperties == null && key != null && value != null) { this.clusterOSImageProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.clusterOSImageProperties.put(key, value);} return (A)this;
  }
  public A addToClusterOSImageProperties(Map<String,String> map) {
    if(this.clusterOSImageProperties == null && map != null) { this.clusterOSImageProperties = new LinkedHashMap(); }
    if(map != null) { this.clusterOSImageProperties.putAll(map);} return (A)this;
  }
  public A removeFromClusterOSImageProperties(String key) {
    if(this.clusterOSImageProperties == null) { return (A) this; }
    if(key != null && this.clusterOSImageProperties != null) {this.clusterOSImageProperties.remove(key);} return (A)this;
  }
  public A removeFromClusterOSImageProperties(Map<String,String> map) {
    if(this.clusterOSImageProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.clusterOSImageProperties != null){this.clusterOSImageProperties.remove(key);}}} return (A)this;
  }
  public Map<String,String> getClusterOSImageProperties() {
    return this.clusterOSImageProperties;
  }
  public <K,V>A withClusterOSImageProperties(Map<String,String> clusterOSImageProperties) {
    if (clusterOSImageProperties == null) { this.clusterOSImageProperties =  null;} else {this.clusterOSImageProperties = new LinkedHashMap(clusterOSImageProperties);} return (A) this;
  }
  public Boolean hasClusterOSImageProperties() {
    return this.clusterOSImageProperties != null;
  }
  public String getComputeFlavor() {
    return this.computeFlavor;
  }
  public A withComputeFlavor(String computeFlavor) {
    this.computeFlavor=computeFlavor; return (A) this;
  }
  public Boolean hasComputeFlavor() {
    return this.computeFlavor != null;
  }
  
  /**
   * This method has been deprecated, please use method buildDefaultMachinePlatform instead.
   * @return The buildable object.
   */
  @Deprecated
  public MachinePool getDefaultMachinePlatform() {
    return this.defaultMachinePlatform!=null ?this.defaultMachinePlatform.build():null;
  }
  public MachinePool buildDefaultMachinePlatform() {
    return this.defaultMachinePlatform!=null ?this.defaultMachinePlatform.build():null;
  }
  public A withDefaultMachinePlatform(MachinePool defaultMachinePlatform) {
    _visitables.get("defaultMachinePlatform").remove(this.defaultMachinePlatform);
    if (defaultMachinePlatform!=null){ this.defaultMachinePlatform= new MachinePoolBuilder(defaultMachinePlatform); _visitables.get("defaultMachinePlatform").add(this.defaultMachinePlatform);} else { this.defaultMachinePlatform = null; _visitables.get("defaultMachinePlatform").remove(this.defaultMachinePlatform); } return (A) this;
  }
  public Boolean hasDefaultMachinePlatform() {
    return this.defaultMachinePlatform != null;
  }
  public PlatformFluent.DefaultMachinePlatformNested<A> withNewDefaultMachinePlatform() {
    return new PlatformFluentImpl.DefaultMachinePlatformNestedImpl();
  }
  public PlatformFluent.DefaultMachinePlatformNested<A> withNewDefaultMachinePlatformLike(MachinePool item) {
    return new PlatformFluentImpl.DefaultMachinePlatformNestedImpl(item);
  }
  public PlatformFluent.DefaultMachinePlatformNested<A> editDefaultMachinePlatform() {
    return withNewDefaultMachinePlatformLike(getDefaultMachinePlatform());
  }
  public PlatformFluent.DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatform() {
    return withNewDefaultMachinePlatformLike(getDefaultMachinePlatform() != null ? getDefaultMachinePlatform(): new MachinePoolBuilder().build());
  }
  public PlatformFluent.DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatformLike(MachinePool item) {
    return withNewDefaultMachinePlatformLike(getDefaultMachinePlatform() != null ? getDefaultMachinePlatform(): item);
  }
  public A addToExternalDNS(Integer index,String item) {
    if (this.externalDNS == null) {this.externalDNS = new ArrayList<String>();}
    this.externalDNS.add(index, item);
    return (A)this;
  }
  public A setToExternalDNS(Integer index,String item) {
    if (this.externalDNS == null) {this.externalDNS = new ArrayList<String>();}
    this.externalDNS.set(index, item); return (A)this;
  }
  public A addToExternalDNS(java.lang.String... items) {
    if (this.externalDNS == null) {this.externalDNS = new ArrayList<String>();}
    for (String item : items) {this.externalDNS.add(item);} return (A)this;
  }
  public A addAllToExternalDNS(Collection<String> items) {
    if (this.externalDNS == null) {this.externalDNS = new ArrayList<String>();}
    for (String item : items) {this.externalDNS.add(item);} return (A)this;
  }
  public A removeFromExternalDNS(java.lang.String... items) {
    for (String item : items) {if (this.externalDNS!= null){ this.externalDNS.remove(item);}} return (A)this;
  }
  public A removeAllFromExternalDNS(Collection<String> items) {
    for (String item : items) {if (this.externalDNS!= null){ this.externalDNS.remove(item);}} return (A)this;
  }
  public List<String> getExternalDNS() {
    return this.externalDNS;
  }
  public String getExternalDN(Integer index) {
    return this.externalDNS.get(index);
  }
  public String getFirstExternalDN() {
    return this.externalDNS.get(0);
  }
  public String getLastExternalDN() {
    return this.externalDNS.get(externalDNS.size() - 1);
  }
  public String getMatchingExternalDN(Predicate<String> predicate) {
    for (String item: externalDNS) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingExternalDN(Predicate<String> predicate) {
    for (String item: externalDNS) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withExternalDNS(List<String> externalDNS) {
    if (externalDNS != null) {this.externalDNS = new ArrayList(); for (String item : externalDNS){this.addToExternalDNS(item);}} else { this.externalDNS = null;} return (A) this;
  }
  public A withExternalDNS(java.lang.String... externalDNS) {
    if (this.externalDNS != null) {this.externalDNS.clear();}
    if (externalDNS != null) {for (String item :externalDNS){ this.addToExternalDNS(item);}} return (A) this;
  }
  public Boolean hasExternalDNS() {
    return externalDNS != null && !externalDNS.isEmpty();
  }
  public String getExternalNetwork() {
    return this.externalNetwork;
  }
  public A withExternalNetwork(String externalNetwork) {
    this.externalNetwork=externalNetwork; return (A) this;
  }
  public Boolean hasExternalNetwork() {
    return this.externalNetwork != null;
  }
  public String getIngressFloatingIP() {
    return this.ingressFloatingIP;
  }
  public A withIngressFloatingIP(String ingressFloatingIP) {
    this.ingressFloatingIP=ingressFloatingIP; return (A) this;
  }
  public Boolean hasIngressFloatingIP() {
    return this.ingressFloatingIP != null;
  }
  public String getIngressVIP() {
    return this.ingressVIP;
  }
  public A withIngressVIP(String ingressVIP) {
    this.ingressVIP=ingressVIP; return (A) this;
  }
  public Boolean hasIngressVIP() {
    return this.ingressVIP != null;
  }
  public String getLbFloatingIP() {
    return this.lbFloatingIP;
  }
  public A withLbFloatingIP(String lbFloatingIP) {
    this.lbFloatingIP=lbFloatingIP; return (A) this;
  }
  public Boolean hasLbFloatingIP() {
    return this.lbFloatingIP != null;
  }
  public String getMachinesSubnet() {
    return this.machinesSubnet;
  }
  public A withMachinesSubnet(String machinesSubnet) {
    this.machinesSubnet=machinesSubnet; return (A) this;
  }
  public Boolean hasMachinesSubnet() {
    return this.machinesSubnet != null;
  }
  public String getOctaviaSupport() {
    return this.octaviaSupport;
  }
  public A withOctaviaSupport(String octaviaSupport) {
    this.octaviaSupport=octaviaSupport; return (A) this;
  }
  public Boolean hasOctaviaSupport() {
    return this.octaviaSupport != null;
  }
  public String getRegion() {
    return this.region;
  }
  public A withRegion(String region) {
    this.region=region; return (A) this;
  }
  public Boolean hasRegion() {
    return this.region != null;
  }
  public String getTrunkSupport() {
    return this.trunkSupport;
  }
  public A withTrunkSupport(String trunkSupport) {
    this.trunkSupport=trunkSupport; return (A) this;
  }
  public Boolean hasTrunkSupport() {
    return this.trunkSupport != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PlatformFluentImpl that = (PlatformFluentImpl) o;
    if (apiFloatingIP != null ? !apiFloatingIP.equals(that.apiFloatingIP) :that.apiFloatingIP != null) return false;
    if (apiVIP != null ? !apiVIP.equals(that.apiVIP) :that.apiVIP != null) return false;
    if (cloud != null ? !cloud.equals(that.cloud) :that.cloud != null) return false;
    if (clusterOSImage != null ? !clusterOSImage.equals(that.clusterOSImage) :that.clusterOSImage != null) return false;
    if (clusterOSImageProperties != null ? !clusterOSImageProperties.equals(that.clusterOSImageProperties) :that.clusterOSImageProperties != null) return false;
    if (computeFlavor != null ? !computeFlavor.equals(that.computeFlavor) :that.computeFlavor != null) return false;
    if (defaultMachinePlatform != null ? !defaultMachinePlatform.equals(that.defaultMachinePlatform) :that.defaultMachinePlatform != null) return false;
    if (externalDNS != null ? !externalDNS.equals(that.externalDNS) :that.externalDNS != null) return false;
    if (externalNetwork != null ? !externalNetwork.equals(that.externalNetwork) :that.externalNetwork != null) return false;
    if (ingressFloatingIP != null ? !ingressFloatingIP.equals(that.ingressFloatingIP) :that.ingressFloatingIP != null) return false;
    if (ingressVIP != null ? !ingressVIP.equals(that.ingressVIP) :that.ingressVIP != null) return false;
    if (lbFloatingIP != null ? !lbFloatingIP.equals(that.lbFloatingIP) :that.lbFloatingIP != null) return false;
    if (machinesSubnet != null ? !machinesSubnet.equals(that.machinesSubnet) :that.machinesSubnet != null) return false;
    if (octaviaSupport != null ? !octaviaSupport.equals(that.octaviaSupport) :that.octaviaSupport != null) return false;
    if (region != null ? !region.equals(that.region) :that.region != null) return false;
    if (trunkSupport != null ? !trunkSupport.equals(that.trunkSupport) :that.trunkSupport != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiFloatingIP,  apiVIP,  cloud,  clusterOSImage,  clusterOSImageProperties,  computeFlavor,  defaultMachinePlatform,  externalDNS,  externalNetwork,  ingressFloatingIP,  ingressVIP,  lbFloatingIP,  machinesSubnet,  octaviaSupport,  region,  trunkSupport,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiFloatingIP != null) { sb.append("apiFloatingIP:"); sb.append(apiFloatingIP + ","); }
    if (apiVIP != null) { sb.append("apiVIP:"); sb.append(apiVIP + ","); }
    if (cloud != null) { sb.append("cloud:"); sb.append(cloud + ","); }
    if (clusterOSImage != null) { sb.append("clusterOSImage:"); sb.append(clusterOSImage + ","); }
    if (clusterOSImageProperties != null && !clusterOSImageProperties.isEmpty()) { sb.append("clusterOSImageProperties:"); sb.append(clusterOSImageProperties + ","); }
    if (computeFlavor != null) { sb.append("computeFlavor:"); sb.append(computeFlavor + ","); }
    if (defaultMachinePlatform != null) { sb.append("defaultMachinePlatform:"); sb.append(defaultMachinePlatform + ","); }
    if (externalDNS != null && !externalDNS.isEmpty()) { sb.append("externalDNS:"); sb.append(externalDNS + ","); }
    if (externalNetwork != null) { sb.append("externalNetwork:"); sb.append(externalNetwork + ","); }
    if (ingressFloatingIP != null) { sb.append("ingressFloatingIP:"); sb.append(ingressFloatingIP + ","); }
    if (ingressVIP != null) { sb.append("ingressVIP:"); sb.append(ingressVIP + ","); }
    if (lbFloatingIP != null) { sb.append("lbFloatingIP:"); sb.append(lbFloatingIP + ","); }
    if (machinesSubnet != null) { sb.append("machinesSubnet:"); sb.append(machinesSubnet + ","); }
    if (octaviaSupport != null) { sb.append("octaviaSupport:"); sb.append(octaviaSupport + ","); }
    if (region != null) { sb.append("region:"); sb.append(region + ","); }
    if (trunkSupport != null) { sb.append("trunkSupport:"); sb.append(trunkSupport + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class DefaultMachinePlatformNestedImpl<N> extends MachinePoolFluentImpl<PlatformFluent.DefaultMachinePlatformNested<N>> implements PlatformFluent.DefaultMachinePlatformNested<N>,Nested<N>{
    DefaultMachinePlatformNestedImpl(MachinePool item) {
      this.builder = new MachinePoolBuilder(this, item);
    }
    DefaultMachinePlatformNestedImpl() {
      this.builder = new MachinePoolBuilder(this);
    }
    MachinePoolBuilder builder;
    public N and() {
      return (N) PlatformFluentImpl.this.withDefaultMachinePlatform(builder.build());
    }
    public N endDefaultMachinePlatform() {
      return and();
    }
    
  }
  
}