package io.fabric8.openshift.api.model.installer.ovirt.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AffinityGroupBuilder extends AffinityGroupFluentImpl<AffinityGroupBuilder> implements VisitableBuilder<AffinityGroup,AffinityGroupBuilder>{
  public AffinityGroupBuilder() {
    this(false);
  }
  public AffinityGroupBuilder(Boolean validationEnabled) {
    this(new AffinityGroup(), validationEnabled);
  }
  public AffinityGroupBuilder(AffinityGroupFluent<?> fluent) {
    this(fluent, false);
  }
  public AffinityGroupBuilder(AffinityGroupFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AffinityGroup(), validationEnabled);
  }
  public AffinityGroupBuilder(AffinityGroupFluent<?> fluent,AffinityGroup instance) {
    this(fluent, instance, false);
  }
  public AffinityGroupBuilder(AffinityGroupFluent<?> fluent,AffinityGroup instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withDescription(instance.getDescription()); 
    fluent.withEnforcing(instance.getEnforcing()); 
    fluent.withName(instance.getName()); 
    fluent.withPriority(instance.getPriority()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public AffinityGroupBuilder(AffinityGroup instance) {
    this(instance,false);
  }
  public AffinityGroupBuilder(AffinityGroup instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withDescription(instance.getDescription()); 
    this.withEnforcing(instance.getEnforcing()); 
    this.withName(instance.getName()); 
    this.withPriority(instance.getPriority()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  AffinityGroupFluent<?> fluent;
  Boolean validationEnabled;
  public AffinityGroup build() {
    AffinityGroup buildable = new AffinityGroup(fluent.getDescription(),fluent.getEnforcing(),fluent.getName(),fluent.getPriority());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}