package io.fabric8.openshift.api.model.installer.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public interface NetworkingFluent<A extends NetworkingFluent<A>> extends Fluent<A>{
  public A addToClusterNetwork(Integer index,ClusterNetworkEntry item);
  public A setToClusterNetwork(Integer index,ClusterNetworkEntry item);
  public A addToClusterNetwork(io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry... items);
  public A addAllToClusterNetwork(Collection<ClusterNetworkEntry> items);
  public A removeFromClusterNetwork(io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry... items);
  public A removeAllFromClusterNetwork(Collection<ClusterNetworkEntry> items);
  public A removeMatchingFromClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildClusterNetwork instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ClusterNetworkEntry> getClusterNetwork();
  public List<ClusterNetworkEntry> buildClusterNetwork();
  public ClusterNetworkEntry buildClusterNetwork(Integer index);
  public ClusterNetworkEntry buildFirstClusterNetwork();
  public ClusterNetworkEntry buildLastClusterNetwork();
  public ClusterNetworkEntry buildMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate);
  public Boolean hasMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate);
  public A withClusterNetwork(List<ClusterNetworkEntry> clusterNetwork);
  public A withClusterNetwork(io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry... clusterNetwork);
  public Boolean hasClusterNetwork();
  public A addNewClusterNetwork(String cidr,Integer hostPrefix,Integer hostSubnetLength);
  public NetworkingFluent.ClusterNetworkNested<A> addNewClusterNetwork();
  public NetworkingFluent.ClusterNetworkNested<A> addNewClusterNetworkLike(ClusterNetworkEntry item);
  public NetworkingFluent.ClusterNetworkNested<A> setNewClusterNetworkLike(Integer index,ClusterNetworkEntry item);
  public NetworkingFluent.ClusterNetworkNested<A> editClusterNetwork(Integer index);
  public NetworkingFluent.ClusterNetworkNested<A> editFirstClusterNetwork();
  public NetworkingFluent.ClusterNetworkNested<A> editLastClusterNetwork();
  public NetworkingFluent.ClusterNetworkNested<A> editMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate);
  public A addToDeprecatedClusterNetworks(Integer index,ClusterNetworkEntry item);
  public A setToDeprecatedClusterNetworks(Integer index,ClusterNetworkEntry item);
  public A addToDeprecatedClusterNetworks(io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry... items);
  public A addAllToDeprecatedClusterNetworks(Collection<ClusterNetworkEntry> items);
  public A removeFromDeprecatedClusterNetworks(io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry... items);
  public A removeAllFromDeprecatedClusterNetworks(Collection<ClusterNetworkEntry> items);
  public A removeMatchingFromDeprecatedClusterNetworks(Predicate<ClusterNetworkEntryBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildDeprecatedClusterNetworks instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ClusterNetworkEntry> getDeprecatedClusterNetworks();
  public List<ClusterNetworkEntry> buildDeprecatedClusterNetworks();
  public ClusterNetworkEntry buildDeprecatedClusterNetwork(Integer index);
  public ClusterNetworkEntry buildFirstDeprecatedClusterNetwork();
  public ClusterNetworkEntry buildLastDeprecatedClusterNetwork();
  public ClusterNetworkEntry buildMatchingDeprecatedClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate);
  public Boolean hasMatchingDeprecatedClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate);
  public A withDeprecatedClusterNetworks(List<ClusterNetworkEntry> deprecatedClusterNetworks);
  public A withDeprecatedClusterNetworks(io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry... deprecatedClusterNetworks);
  public Boolean hasDeprecatedClusterNetworks();
  public A addNewDeprecatedClusterNetwork(String cidr,Integer hostPrefix,Integer hostSubnetLength);
  public NetworkingFluent.DeprecatedClusterNetworksNested<A> addNewDeprecatedClusterNetwork();
  public NetworkingFluent.DeprecatedClusterNetworksNested<A> addNewDeprecatedClusterNetworkLike(ClusterNetworkEntry item);
  public NetworkingFluent.DeprecatedClusterNetworksNested<A> setNewDeprecatedClusterNetworkLike(Integer index,ClusterNetworkEntry item);
  public NetworkingFluent.DeprecatedClusterNetworksNested<A> editDeprecatedClusterNetwork(Integer index);
  public NetworkingFluent.DeprecatedClusterNetworksNested<A> editFirstDeprecatedClusterNetwork();
  public NetworkingFluent.DeprecatedClusterNetworksNested<A> editLastDeprecatedClusterNetwork();
  public NetworkingFluent.DeprecatedClusterNetworksNested<A> editMatchingDeprecatedClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate);
  public String getMachineCIDR();
  public A withMachineCIDR(String machineCIDR);
  public Boolean hasMachineCIDR();
  public A addToMachineNetwork(Integer index,MachineNetworkEntry item);
  public A setToMachineNetwork(Integer index,MachineNetworkEntry item);
  public A addToMachineNetwork(io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntry... items);
  public A addAllToMachineNetwork(Collection<MachineNetworkEntry> items);
  public A removeFromMachineNetwork(io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntry... items);
  public A removeAllFromMachineNetwork(Collection<MachineNetworkEntry> items);
  public A removeMatchingFromMachineNetwork(Predicate<MachineNetworkEntryBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildMachineNetwork instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<MachineNetworkEntry> getMachineNetwork();
  public List<MachineNetworkEntry> buildMachineNetwork();
  public MachineNetworkEntry buildMachineNetwork(Integer index);
  public MachineNetworkEntry buildFirstMachineNetwork();
  public MachineNetworkEntry buildLastMachineNetwork();
  public MachineNetworkEntry buildMatchingMachineNetwork(Predicate<MachineNetworkEntryBuilder> predicate);
  public Boolean hasMatchingMachineNetwork(Predicate<MachineNetworkEntryBuilder> predicate);
  public A withMachineNetwork(List<MachineNetworkEntry> machineNetwork);
  public A withMachineNetwork(io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntry... machineNetwork);
  public Boolean hasMachineNetwork();
  public A addNewMachineNetwork(String cidr);
  public NetworkingFluent.MachineNetworkNested<A> addNewMachineNetwork();
  public NetworkingFluent.MachineNetworkNested<A> addNewMachineNetworkLike(MachineNetworkEntry item);
  public NetworkingFluent.MachineNetworkNested<A> setNewMachineNetworkLike(Integer index,MachineNetworkEntry item);
  public NetworkingFluent.MachineNetworkNested<A> editMachineNetwork(Integer index);
  public NetworkingFluent.MachineNetworkNested<A> editFirstMachineNetwork();
  public NetworkingFluent.MachineNetworkNested<A> editLastMachineNetwork();
  public NetworkingFluent.MachineNetworkNested<A> editMatchingMachineNetwork(Predicate<MachineNetworkEntryBuilder> predicate);
  public String getNetworkType();
  public A withNetworkType(String networkType);
  public Boolean hasNetworkType();
  public String getServiceCIDR();
  public A withServiceCIDR(String serviceCIDR);
  public Boolean hasServiceCIDR();
  public A addToServiceNetwork(Integer index,String item);
  public A setToServiceNetwork(Integer index,String item);
  public A addToServiceNetwork(java.lang.String... items);
  public A addAllToServiceNetwork(Collection<String> items);
  public A removeFromServiceNetwork(java.lang.String... items);
  public A removeAllFromServiceNetwork(Collection<String> items);
  public List<String> getServiceNetwork();
  public String getServiceNetwork(Integer index);
  public String getFirstServiceNetwork();
  public String getLastServiceNetwork();
  public String getMatchingServiceNetwork(Predicate<String> predicate);
  public Boolean hasMatchingServiceNetwork(Predicate<String> predicate);
  public A withServiceNetwork(List<String> serviceNetwork);
  public A withServiceNetwork(java.lang.String... serviceNetwork);
  public Boolean hasServiceNetwork();
  public String getType();
  public A withType(String type);
  public Boolean hasType();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface ClusterNetworkNested<N> extends Nested<N>,ClusterNetworkEntryFluent<NetworkingFluent.ClusterNetworkNested<N>>{
    public N and();
    public N endClusterNetwork();
    
  }
  public interface DeprecatedClusterNetworksNested<N> extends Nested<N>,ClusterNetworkEntryFluent<NetworkingFluent.DeprecatedClusterNetworksNested<N>>{
    public N and();
    public N endDeprecatedClusterNetwork();
    
  }
  public interface MachineNetworkNested<N> extends Nested<N>,MachineNetworkEntryFluent<NetworkingFluent.MachineNetworkNested<N>>{
    public N and();
    public N endMachineNetwork();
    
  }
  
}