package io.fabric8.openshift.api.model.installer.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PlatformBuilder extends PlatformFluentImpl<PlatformBuilder> implements VisitableBuilder<Platform,PlatformBuilder>{
  public PlatformBuilder() {
    this(false);
  }
  public PlatformBuilder(Boolean validationEnabled) {
    this(new Platform(), validationEnabled);
  }
  public PlatformBuilder(PlatformFluent<?> fluent) {
    this(fluent, false);
  }
  public PlatformBuilder(PlatformFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Platform(), validationEnabled);
  }
  public PlatformBuilder(PlatformFluent<?> fluent,Platform instance) {
    this(fluent, instance, false);
  }
  public PlatformBuilder(PlatformFluent<?> fluent,Platform instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAlibabacloud(instance.getAlibabacloud()); 
    fluent.withAws(instance.getAws()); 
    fluent.withAzure(instance.getAzure()); 
    fluent.withBaremetal(instance.getBaremetal()); 
    fluent.withGcp(instance.getGcp()); 
    fluent.withIbmcloud(instance.getIbmcloud()); 
    fluent.withLibvirt(instance.getLibvirt()); 
    fluent.withNone(instance.getNone()); 
    fluent.withOpenstack(instance.getOpenstack()); 
    fluent.withOvirt(instance.getOvirt()); 
    fluent.withVsphere(instance.getVsphere()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PlatformBuilder(Platform instance) {
    this(instance,false);
  }
  public PlatformBuilder(Platform instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAlibabacloud(instance.getAlibabacloud()); 
    this.withAws(instance.getAws()); 
    this.withAzure(instance.getAzure()); 
    this.withBaremetal(instance.getBaremetal()); 
    this.withGcp(instance.getGcp()); 
    this.withIbmcloud(instance.getIbmcloud()); 
    this.withLibvirt(instance.getLibvirt()); 
    this.withNone(instance.getNone()); 
    this.withOpenstack(instance.getOpenstack()); 
    this.withOvirt(instance.getOvirt()); 
    this.withVsphere(instance.getVsphere()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  PlatformFluent<?> fluent;
  Boolean validationEnabled;
  public Platform build() {
    Platform buildable = new Platform(fluent.getAlibabacloud(),fluent.getAws(),fluent.getAzure(),fluent.getBaremetal(),fluent.getGcp(),fluent.getIbmcloud(),fluent.getLibvirt(),fluent.getNone(),fluent.getOpenstack(),fluent.getOvirt(),fluent.getVsphere());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}