package io.fabric8.openshift.api.model.installer.openstack.v1;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class RootVolumeFluentImpl<A extends RootVolumeFluent<A>> extends BaseFluent<A> implements RootVolumeFluent<A>{
  public RootVolumeFluentImpl() {
  }
  public RootVolumeFluentImpl(RootVolume instance) {
    this.withSize(instance.getSize()); 
    this.withType(instance.getType()); 
    this.withZones(instance.getZones()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private Integer size;
  private String type;
  private List<String> zones = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  public Integer getSize() {
    return this.size;
  }
  public A withSize(Integer size) {
    this.size=size; return (A) this;
  }
  public Boolean hasSize() {
    return this.size != null;
  }
  public String getType() {
    return this.type;
  }
  public A withType(String type) {
    this.type=type; return (A) this;
  }
  public Boolean hasType() {
    return this.type != null;
  }
  public A addToZones(Integer index,String item) {
    if (this.zones == null) {this.zones = new ArrayList<String>();}
    this.zones.add(index, item);
    return (A)this;
  }
  public A setToZones(Integer index,String item) {
    if (this.zones == null) {this.zones = new ArrayList<String>();}
    this.zones.set(index, item); return (A)this;
  }
  public A addToZones(java.lang.String... items) {
    if (this.zones == null) {this.zones = new ArrayList<String>();}
    for (String item : items) {this.zones.add(item);} return (A)this;
  }
  public A addAllToZones(Collection<String> items) {
    if (this.zones == null) {this.zones = new ArrayList<String>();}
    for (String item : items) {this.zones.add(item);} return (A)this;
  }
  public A removeFromZones(java.lang.String... items) {
    for (String item : items) {if (this.zones!= null){ this.zones.remove(item);}} return (A)this;
  }
  public A removeAllFromZones(Collection<String> items) {
    for (String item : items) {if (this.zones!= null){ this.zones.remove(item);}} return (A)this;
  }
  public List<String> getZones() {
    return this.zones;
  }
  public String getZone(Integer index) {
    return this.zones.get(index);
  }
  public String getFirstZone() {
    return this.zones.get(0);
  }
  public String getLastZone() {
    return this.zones.get(zones.size() - 1);
  }
  public String getMatchingZone(Predicate<String> predicate) {
    for (String item: zones) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingZone(Predicate<String> predicate) {
    for (String item: zones) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withZones(List<String> zones) {
    if (zones != null) {this.zones = new ArrayList(); for (String item : zones){this.addToZones(item);}} else { this.zones = null;} return (A) this;
  }
  public A withZones(java.lang.String... zones) {
    if (this.zones != null) {this.zones.clear();}
    if (zones != null) {for (String item :zones){ this.addToZones(item);}} return (A) this;
  }
  public Boolean hasZones() {
    return zones != null && !zones.isEmpty();
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RootVolumeFluentImpl that = (RootVolumeFluentImpl) o;
    if (size != null ? !size.equals(that.size) :that.size != null) return false;
    if (type != null ? !type.equals(that.type) :that.type != null) return false;
    if (zones != null ? !zones.equals(that.zones) :that.zones != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(size,  type,  zones,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (size != null) { sb.append("size:"); sb.append(size + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (zones != null && !zones.isEmpty()) { sb.append("zones:"); sb.append(zones + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
}