package io.fabric8.openshift.api.model.installer.azure.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PlatformFluentImpl<A extends PlatformFluent<A>> extends BaseFluent<A> implements PlatformFluent<A>{
  public PlatformFluentImpl() {
  }
  public PlatformFluentImpl(Platform instance) {
    this.withArmEndpoint(instance.getArmEndpoint()); 
    this.withBaseDomainResourceGroupName(instance.getBaseDomainResourceGroupName()); 
    this.withCloudName(instance.getCloudName()); 
    this.withClusterOSImage(instance.getClusterOSImage()); 
    this.withComputeSubnet(instance.getComputeSubnet()); 
    this.withControlPlaneSubnet(instance.getControlPlaneSubnet()); 
    this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform()); 
    this.withNetworkResourceGroupName(instance.getNetworkResourceGroupName()); 
    this.withOutboundType(instance.getOutboundType()); 
    this.withRegion(instance.getRegion()); 
    this.withResourceGroupName(instance.getResourceGroupName()); 
    this.withVirtualNetwork(instance.getVirtualNetwork()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String armEndpoint;
  private String baseDomainResourceGroupName;
  private String cloudName;
  private String clusterOSImage;
  private String computeSubnet;
  private String controlPlaneSubnet;
  private MachinePoolBuilder defaultMachinePlatform;
  private String networkResourceGroupName;
  private String outboundType;
  private String region;
  private String resourceGroupName;
  private String virtualNetwork;
  private Map<String,Object> additionalProperties;
  public String getArmEndpoint() {
    return this.armEndpoint;
  }
  public A withArmEndpoint(String armEndpoint) {
    this.armEndpoint=armEndpoint; return (A) this;
  }
  public Boolean hasArmEndpoint() {
    return this.armEndpoint != null;
  }
  public String getBaseDomainResourceGroupName() {
    return this.baseDomainResourceGroupName;
  }
  public A withBaseDomainResourceGroupName(String baseDomainResourceGroupName) {
    this.baseDomainResourceGroupName=baseDomainResourceGroupName; return (A) this;
  }
  public Boolean hasBaseDomainResourceGroupName() {
    return this.baseDomainResourceGroupName != null;
  }
  public String getCloudName() {
    return this.cloudName;
  }
  public A withCloudName(String cloudName) {
    this.cloudName=cloudName; return (A) this;
  }
  public Boolean hasCloudName() {
    return this.cloudName != null;
  }
  public String getClusterOSImage() {
    return this.clusterOSImage;
  }
  public A withClusterOSImage(String clusterOSImage) {
    this.clusterOSImage=clusterOSImage; return (A) this;
  }
  public Boolean hasClusterOSImage() {
    return this.clusterOSImage != null;
  }
  public String getComputeSubnet() {
    return this.computeSubnet;
  }
  public A withComputeSubnet(String computeSubnet) {
    this.computeSubnet=computeSubnet; return (A) this;
  }
  public Boolean hasComputeSubnet() {
    return this.computeSubnet != null;
  }
  public String getControlPlaneSubnet() {
    return this.controlPlaneSubnet;
  }
  public A withControlPlaneSubnet(String controlPlaneSubnet) {
    this.controlPlaneSubnet=controlPlaneSubnet; return (A) this;
  }
  public Boolean hasControlPlaneSubnet() {
    return this.controlPlaneSubnet != null;
  }
  
  /**
   * This method has been deprecated, please use method buildDefaultMachinePlatform instead.
   * @return The buildable object.
   */
  @Deprecated
  public MachinePool getDefaultMachinePlatform() {
    return this.defaultMachinePlatform!=null ?this.defaultMachinePlatform.build():null;
  }
  public MachinePool buildDefaultMachinePlatform() {
    return this.defaultMachinePlatform!=null ?this.defaultMachinePlatform.build():null;
  }
  public A withDefaultMachinePlatform(MachinePool defaultMachinePlatform) {
    _visitables.get("defaultMachinePlatform").remove(this.defaultMachinePlatform);
    if (defaultMachinePlatform!=null){ this.defaultMachinePlatform= new MachinePoolBuilder(defaultMachinePlatform); _visitables.get("defaultMachinePlatform").add(this.defaultMachinePlatform);} else { this.defaultMachinePlatform = null; _visitables.get("defaultMachinePlatform").remove(this.defaultMachinePlatform); } return (A) this;
  }
  public Boolean hasDefaultMachinePlatform() {
    return this.defaultMachinePlatform != null;
  }
  public PlatformFluent.DefaultMachinePlatformNested<A> withNewDefaultMachinePlatform() {
    return new PlatformFluentImpl.DefaultMachinePlatformNestedImpl();
  }
  public PlatformFluent.DefaultMachinePlatformNested<A> withNewDefaultMachinePlatformLike(MachinePool item) {
    return new PlatformFluentImpl.DefaultMachinePlatformNestedImpl(item);
  }
  public PlatformFluent.DefaultMachinePlatformNested<A> editDefaultMachinePlatform() {
    return withNewDefaultMachinePlatformLike(getDefaultMachinePlatform());
  }
  public PlatformFluent.DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatform() {
    return withNewDefaultMachinePlatformLike(getDefaultMachinePlatform() != null ? getDefaultMachinePlatform(): new MachinePoolBuilder().build());
  }
  public PlatformFluent.DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatformLike(MachinePool item) {
    return withNewDefaultMachinePlatformLike(getDefaultMachinePlatform() != null ? getDefaultMachinePlatform(): item);
  }
  public String getNetworkResourceGroupName() {
    return this.networkResourceGroupName;
  }
  public A withNetworkResourceGroupName(String networkResourceGroupName) {
    this.networkResourceGroupName=networkResourceGroupName; return (A) this;
  }
  public Boolean hasNetworkResourceGroupName() {
    return this.networkResourceGroupName != null;
  }
  public String getOutboundType() {
    return this.outboundType;
  }
  public A withOutboundType(String outboundType) {
    this.outboundType=outboundType; return (A) this;
  }
  public Boolean hasOutboundType() {
    return this.outboundType != null;
  }
  public String getRegion() {
    return this.region;
  }
  public A withRegion(String region) {
    this.region=region; return (A) this;
  }
  public Boolean hasRegion() {
    return this.region != null;
  }
  public String getResourceGroupName() {
    return this.resourceGroupName;
  }
  public A withResourceGroupName(String resourceGroupName) {
    this.resourceGroupName=resourceGroupName; return (A) this;
  }
  public Boolean hasResourceGroupName() {
    return this.resourceGroupName != null;
  }
  public String getVirtualNetwork() {
    return this.virtualNetwork;
  }
  public A withVirtualNetwork(String virtualNetwork) {
    this.virtualNetwork=virtualNetwork; return (A) this;
  }
  public Boolean hasVirtualNetwork() {
    return this.virtualNetwork != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PlatformFluentImpl that = (PlatformFluentImpl) o;
    if (armEndpoint != null ? !armEndpoint.equals(that.armEndpoint) :that.armEndpoint != null) return false;
    if (baseDomainResourceGroupName != null ? !baseDomainResourceGroupName.equals(that.baseDomainResourceGroupName) :that.baseDomainResourceGroupName != null) return false;
    if (cloudName != null ? !cloudName.equals(that.cloudName) :that.cloudName != null) return false;
    if (clusterOSImage != null ? !clusterOSImage.equals(that.clusterOSImage) :that.clusterOSImage != null) return false;
    if (computeSubnet != null ? !computeSubnet.equals(that.computeSubnet) :that.computeSubnet != null) return false;
    if (controlPlaneSubnet != null ? !controlPlaneSubnet.equals(that.controlPlaneSubnet) :that.controlPlaneSubnet != null) return false;
    if (defaultMachinePlatform != null ? !defaultMachinePlatform.equals(that.defaultMachinePlatform) :that.defaultMachinePlatform != null) return false;
    if (networkResourceGroupName != null ? !networkResourceGroupName.equals(that.networkResourceGroupName) :that.networkResourceGroupName != null) return false;
    if (outboundType != null ? !outboundType.equals(that.outboundType) :that.outboundType != null) return false;
    if (region != null ? !region.equals(that.region) :that.region != null) return false;
    if (resourceGroupName != null ? !resourceGroupName.equals(that.resourceGroupName) :that.resourceGroupName != null) return false;
    if (virtualNetwork != null ? !virtualNetwork.equals(that.virtualNetwork) :that.virtualNetwork != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(armEndpoint,  baseDomainResourceGroupName,  cloudName,  clusterOSImage,  computeSubnet,  controlPlaneSubnet,  defaultMachinePlatform,  networkResourceGroupName,  outboundType,  region,  resourceGroupName,  virtualNetwork,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (armEndpoint != null) { sb.append("armEndpoint:"); sb.append(armEndpoint + ","); }
    if (baseDomainResourceGroupName != null) { sb.append("baseDomainResourceGroupName:"); sb.append(baseDomainResourceGroupName + ","); }
    if (cloudName != null) { sb.append("cloudName:"); sb.append(cloudName + ","); }
    if (clusterOSImage != null) { sb.append("clusterOSImage:"); sb.append(clusterOSImage + ","); }
    if (computeSubnet != null) { sb.append("computeSubnet:"); sb.append(computeSubnet + ","); }
    if (controlPlaneSubnet != null) { sb.append("controlPlaneSubnet:"); sb.append(controlPlaneSubnet + ","); }
    if (defaultMachinePlatform != null) { sb.append("defaultMachinePlatform:"); sb.append(defaultMachinePlatform + ","); }
    if (networkResourceGroupName != null) { sb.append("networkResourceGroupName:"); sb.append(networkResourceGroupName + ","); }
    if (outboundType != null) { sb.append("outboundType:"); sb.append(outboundType + ","); }
    if (region != null) { sb.append("region:"); sb.append(region + ","); }
    if (resourceGroupName != null) { sb.append("resourceGroupName:"); sb.append(resourceGroupName + ","); }
    if (virtualNetwork != null) { sb.append("virtualNetwork:"); sb.append(virtualNetwork + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class DefaultMachinePlatformNestedImpl<N> extends MachinePoolFluentImpl<PlatformFluent.DefaultMachinePlatformNested<N>> implements PlatformFluent.DefaultMachinePlatformNested<N>,Nested<N>{
    DefaultMachinePlatformNestedImpl(MachinePool item) {
      this.builder = new MachinePoolBuilder(this, item);
    }
    DefaultMachinePlatformNestedImpl() {
      this.builder = new MachinePoolBuilder(this);
    }
    MachinePoolBuilder builder;
    public N and() {
      return (N) PlatformFluentImpl.this.withDefaultMachinePlatform(builder.build());
    }
    public N endDefaultMachinePlatform() {
      return and();
    }
    
  }
  
}