package io.fabric8.openshift.api.model.installer.baremetal.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PlatformFluentImpl<A extends PlatformFluent<A>> extends BaseFluent<A> implements PlatformFluent<A>{
  public PlatformFluentImpl() {
  }
  public PlatformFluentImpl(Platform instance) {
    this.withApiVIP(instance.getApiVIP()); 
    this.withBootstrapOSImage(instance.getBootstrapOSImage()); 
    this.withBootstrapProvisioningIP(instance.getBootstrapProvisioningIP()); 
    this.withClusterOSImage(instance.getClusterOSImage()); 
    this.withClusterProvisioningIP(instance.getClusterProvisioningIP()); 
    this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform()); 
    this.withExternalBridge(instance.getExternalBridge()); 
    this.withExternalMACAddress(instance.getExternalMACAddress()); 
    this.withHosts(instance.getHosts()); 
    this.withIngressVIP(instance.getIngressVIP()); 
    this.withLibvirtURI(instance.getLibvirtURI()); 
    this.withProvisioningBridge(instance.getProvisioningBridge()); 
    this.withProvisioningDHCPExternal(instance.getProvisioningDHCPExternal()); 
    this.withProvisioningDHCPRange(instance.getProvisioningDHCPRange()); 
    this.withProvisioningHostIP(instance.getProvisioningHostIP()); 
    this.withProvisioningMACAddress(instance.getProvisioningMACAddress()); 
    this.withProvisioningNetwork(instance.getProvisioningNetwork()); 
    this.withProvisioningNetworkCIDR(instance.getProvisioningNetworkCIDR()); 
    this.withProvisioningNetworkInterface(instance.getProvisioningNetworkInterface()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String apiVIP;
  private String bootstrapOSImage;
  private String bootstrapProvisioningIP;
  private String clusterOSImage;
  private String clusterProvisioningIP;
  private MachinePoolBuilder defaultMachinePlatform;
  private String externalBridge;
  private String externalMACAddress;
  private ArrayList<HostBuilder> hosts = new ArrayList<HostBuilder>();
  private String ingressVIP;
  private String libvirtURI;
  private String provisioningBridge;
  private Boolean provisioningDHCPExternal;
  private String provisioningDHCPRange;
  private String provisioningHostIP;
  private String provisioningMACAddress;
  private String provisioningNetwork;
  private String provisioningNetworkCIDR;
  private String provisioningNetworkInterface;
  private Map<String,Object> additionalProperties;
  public String getApiVIP() {
    return this.apiVIP;
  }
  public A withApiVIP(String apiVIP) {
    this.apiVIP=apiVIP; return (A) this;
  }
  public Boolean hasApiVIP() {
    return this.apiVIP != null;
  }
  public String getBootstrapOSImage() {
    return this.bootstrapOSImage;
  }
  public A withBootstrapOSImage(String bootstrapOSImage) {
    this.bootstrapOSImage=bootstrapOSImage; return (A) this;
  }
  public Boolean hasBootstrapOSImage() {
    return this.bootstrapOSImage != null;
  }
  public String getBootstrapProvisioningIP() {
    return this.bootstrapProvisioningIP;
  }
  public A withBootstrapProvisioningIP(String bootstrapProvisioningIP) {
    this.bootstrapProvisioningIP=bootstrapProvisioningIP; return (A) this;
  }
  public Boolean hasBootstrapProvisioningIP() {
    return this.bootstrapProvisioningIP != null;
  }
  public String getClusterOSImage() {
    return this.clusterOSImage;
  }
  public A withClusterOSImage(String clusterOSImage) {
    this.clusterOSImage=clusterOSImage; return (A) this;
  }
  public Boolean hasClusterOSImage() {
    return this.clusterOSImage != null;
  }
  public String getClusterProvisioningIP() {
    return this.clusterProvisioningIP;
  }
  public A withClusterProvisioningIP(String clusterProvisioningIP) {
    this.clusterProvisioningIP=clusterProvisioningIP; return (A) this;
  }
  public Boolean hasClusterProvisioningIP() {
    return this.clusterProvisioningIP != null;
  }
  
  /**
   * This method has been deprecated, please use method buildDefaultMachinePlatform instead.
   * @return The buildable object.
   */
  @Deprecated
  public MachinePool getDefaultMachinePlatform() {
    return this.defaultMachinePlatform!=null ?this.defaultMachinePlatform.build():null;
  }
  public MachinePool buildDefaultMachinePlatform() {
    return this.defaultMachinePlatform!=null ?this.defaultMachinePlatform.build():null;
  }
  public A withDefaultMachinePlatform(MachinePool defaultMachinePlatform) {
    _visitables.get("defaultMachinePlatform").remove(this.defaultMachinePlatform);
    if (defaultMachinePlatform!=null){ this.defaultMachinePlatform= new MachinePoolBuilder(defaultMachinePlatform); _visitables.get("defaultMachinePlatform").add(this.defaultMachinePlatform);} else { this.defaultMachinePlatform = null; _visitables.get("defaultMachinePlatform").remove(this.defaultMachinePlatform); } return (A) this;
  }
  public Boolean hasDefaultMachinePlatform() {
    return this.defaultMachinePlatform != null;
  }
  public PlatformFluent.DefaultMachinePlatformNested<A> withNewDefaultMachinePlatform() {
    return new PlatformFluentImpl.DefaultMachinePlatformNestedImpl();
  }
  public PlatformFluent.DefaultMachinePlatformNested<A> withNewDefaultMachinePlatformLike(MachinePool item) {
    return new PlatformFluentImpl.DefaultMachinePlatformNestedImpl(item);
  }
  public PlatformFluent.DefaultMachinePlatformNested<A> editDefaultMachinePlatform() {
    return withNewDefaultMachinePlatformLike(getDefaultMachinePlatform());
  }
  public PlatformFluent.DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatform() {
    return withNewDefaultMachinePlatformLike(getDefaultMachinePlatform() != null ? getDefaultMachinePlatform(): new MachinePoolBuilder().build());
  }
  public PlatformFluent.DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatformLike(MachinePool item) {
    return withNewDefaultMachinePlatformLike(getDefaultMachinePlatform() != null ? getDefaultMachinePlatform(): item);
  }
  public String getExternalBridge() {
    return this.externalBridge;
  }
  public A withExternalBridge(String externalBridge) {
    this.externalBridge=externalBridge; return (A) this;
  }
  public Boolean hasExternalBridge() {
    return this.externalBridge != null;
  }
  public String getExternalMACAddress() {
    return this.externalMACAddress;
  }
  public A withExternalMACAddress(String externalMACAddress) {
    this.externalMACAddress=externalMACAddress; return (A) this;
  }
  public Boolean hasExternalMACAddress() {
    return this.externalMACAddress != null;
  }
  public A addToHosts(Integer index,Host item) {
    if (this.hosts == null) {this.hosts = new ArrayList<HostBuilder>();}
    HostBuilder builder = new HostBuilder(item);_visitables.get("hosts").add(index >= 0 ? index : _visitables.get("hosts").size(), builder);this.hosts.add(index >= 0 ? index : hosts.size(), builder); return (A)this;
  }
  public A setToHosts(Integer index,Host item) {
    if (this.hosts == null) {this.hosts = new ArrayList<HostBuilder>();}
    HostBuilder builder = new HostBuilder(item);
    if (index < 0 || index >= _visitables.get("hosts").size()) { _visitables.get("hosts").add(builder); } else { _visitables.get("hosts").set(index, builder);}
    if (index < 0 || index >= hosts.size()) { hosts.add(builder); } else { hosts.set(index, builder);}
     return (A)this;
  }
  public A addToHosts(io.fabric8.openshift.api.model.installer.baremetal.v1.Host... items) {
    if (this.hosts == null) {this.hosts = new ArrayList<HostBuilder>();}
    for (Host item : items) {HostBuilder builder = new HostBuilder(item);_visitables.get("hosts").add(builder);this.hosts.add(builder);} return (A)this;
  }
  public A addAllToHosts(Collection<Host> items) {
    if (this.hosts == null) {this.hosts = new ArrayList<HostBuilder>();}
    for (Host item : items) {HostBuilder builder = new HostBuilder(item);_visitables.get("hosts").add(builder);this.hosts.add(builder);} return (A)this;
  }
  public A removeFromHosts(io.fabric8.openshift.api.model.installer.baremetal.v1.Host... items) {
    for (Host item : items) {HostBuilder builder = new HostBuilder(item);_visitables.get("hosts").remove(builder);if (this.hosts != null) {this.hosts.remove(builder);}} return (A)this;
  }
  public A removeAllFromHosts(Collection<Host> items) {
    for (Host item : items) {HostBuilder builder = new HostBuilder(item);_visitables.get("hosts").remove(builder);if (this.hosts != null) {this.hosts.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromHosts(Predicate<HostBuilder> predicate) {
    if (hosts == null) return (A) this;
    final Iterator<HostBuilder> each = hosts.iterator();
    final List visitables = _visitables.get("hosts");
    while (each.hasNext()) {
      HostBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildHosts instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Host> getHosts() {
    return hosts != null ? build(hosts) : null;
  }
  public List<Host> buildHosts() {
    return hosts != null ? build(hosts) : null;
  }
  public Host buildHost(Integer index) {
    return this.hosts.get(index).build();
  }
  public Host buildFirstHost() {
    return this.hosts.get(0).build();
  }
  public Host buildLastHost() {
    return this.hosts.get(hosts.size() - 1).build();
  }
  public Host buildMatchingHost(Predicate<HostBuilder> predicate) {
    for (HostBuilder item: hosts) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingHost(Predicate<HostBuilder> predicate) {
    for (HostBuilder item: hosts) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withHosts(List<Host> hosts) {
    if (this.hosts != null) { _visitables.get("hosts").removeAll(this.hosts);}
    if (hosts != null) {this.hosts = new ArrayList(); for (Host item : hosts){this.addToHosts(item);}} else { this.hosts = null;} return (A) this;
  }
  public A withHosts(io.fabric8.openshift.api.model.installer.baremetal.v1.Host... hosts) {
    if (this.hosts != null) {this.hosts.clear();}
    if (hosts != null) {for (Host item :hosts){ this.addToHosts(item);}} return (A) this;
  }
  public Boolean hasHosts() {
    return hosts != null && !hosts.isEmpty();
  }
  public PlatformFluent.HostsNested<A> addNewHost() {
    return new PlatformFluentImpl.HostsNestedImpl();
  }
  public PlatformFluent.HostsNested<A> addNewHostLike(Host item) {
    return new PlatformFluentImpl.HostsNestedImpl(-1, item);
  }
  public PlatformFluent.HostsNested<A> setNewHostLike(Integer index,Host item) {
    return new PlatformFluentImpl.HostsNestedImpl(index, item);
  }
  public PlatformFluent.HostsNested<A> editHost(Integer index) {
    if (hosts.size() <= index) throw new RuntimeException("Can't edit hosts. Index exceeds size.");
    return setNewHostLike(index, buildHost(index));
  }
  public PlatformFluent.HostsNested<A> editFirstHost() {
    if (hosts.size() == 0) throw new RuntimeException("Can't edit first hosts. The list is empty.");
    return setNewHostLike(0, buildHost(0));
  }
  public PlatformFluent.HostsNested<A> editLastHost() {
    int index = hosts.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last hosts. The list is empty.");
    return setNewHostLike(index, buildHost(index));
  }
  public PlatformFluent.HostsNested<A> editMatchingHost(Predicate<HostBuilder> predicate) {
    int index = -1;
    for (int i=0;i<hosts.size();i++) { 
    if (predicate.test(hosts.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching hosts. No match found.");
    return setNewHostLike(index, buildHost(index));
  }
  public String getIngressVIP() {
    return this.ingressVIP;
  }
  public A withIngressVIP(String ingressVIP) {
    this.ingressVIP=ingressVIP; return (A) this;
  }
  public Boolean hasIngressVIP() {
    return this.ingressVIP != null;
  }
  public String getLibvirtURI() {
    return this.libvirtURI;
  }
  public A withLibvirtURI(String libvirtURI) {
    this.libvirtURI=libvirtURI; return (A) this;
  }
  public Boolean hasLibvirtURI() {
    return this.libvirtURI != null;
  }
  public String getProvisioningBridge() {
    return this.provisioningBridge;
  }
  public A withProvisioningBridge(String provisioningBridge) {
    this.provisioningBridge=provisioningBridge; return (A) this;
  }
  public Boolean hasProvisioningBridge() {
    return this.provisioningBridge != null;
  }
  public Boolean getProvisioningDHCPExternal() {
    return this.provisioningDHCPExternal;
  }
  public A withProvisioningDHCPExternal(Boolean provisioningDHCPExternal) {
    this.provisioningDHCPExternal=provisioningDHCPExternal; return (A) this;
  }
  public Boolean hasProvisioningDHCPExternal() {
    return this.provisioningDHCPExternal != null;
  }
  public String getProvisioningDHCPRange() {
    return this.provisioningDHCPRange;
  }
  public A withProvisioningDHCPRange(String provisioningDHCPRange) {
    this.provisioningDHCPRange=provisioningDHCPRange; return (A) this;
  }
  public Boolean hasProvisioningDHCPRange() {
    return this.provisioningDHCPRange != null;
  }
  public String getProvisioningHostIP() {
    return this.provisioningHostIP;
  }
  public A withProvisioningHostIP(String provisioningHostIP) {
    this.provisioningHostIP=provisioningHostIP; return (A) this;
  }
  public Boolean hasProvisioningHostIP() {
    return this.provisioningHostIP != null;
  }
  public String getProvisioningMACAddress() {
    return this.provisioningMACAddress;
  }
  public A withProvisioningMACAddress(String provisioningMACAddress) {
    this.provisioningMACAddress=provisioningMACAddress; return (A) this;
  }
  public Boolean hasProvisioningMACAddress() {
    return this.provisioningMACAddress != null;
  }
  public String getProvisioningNetwork() {
    return this.provisioningNetwork;
  }
  public A withProvisioningNetwork(String provisioningNetwork) {
    this.provisioningNetwork=provisioningNetwork; return (A) this;
  }
  public Boolean hasProvisioningNetwork() {
    return this.provisioningNetwork != null;
  }
  public String getProvisioningNetworkCIDR() {
    return this.provisioningNetworkCIDR;
  }
  public A withProvisioningNetworkCIDR(String provisioningNetworkCIDR) {
    this.provisioningNetworkCIDR=provisioningNetworkCIDR; return (A) this;
  }
  public Boolean hasProvisioningNetworkCIDR() {
    return this.provisioningNetworkCIDR != null;
  }
  public String getProvisioningNetworkInterface() {
    return this.provisioningNetworkInterface;
  }
  public A withProvisioningNetworkInterface(String provisioningNetworkInterface) {
    this.provisioningNetworkInterface=provisioningNetworkInterface; return (A) this;
  }
  public Boolean hasProvisioningNetworkInterface() {
    return this.provisioningNetworkInterface != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PlatformFluentImpl that = (PlatformFluentImpl) o;
    if (apiVIP != null ? !apiVIP.equals(that.apiVIP) :that.apiVIP != null) return false;
    if (bootstrapOSImage != null ? !bootstrapOSImage.equals(that.bootstrapOSImage) :that.bootstrapOSImage != null) return false;
    if (bootstrapProvisioningIP != null ? !bootstrapProvisioningIP.equals(that.bootstrapProvisioningIP) :that.bootstrapProvisioningIP != null) return false;
    if (clusterOSImage != null ? !clusterOSImage.equals(that.clusterOSImage) :that.clusterOSImage != null) return false;
    if (clusterProvisioningIP != null ? !clusterProvisioningIP.equals(that.clusterProvisioningIP) :that.clusterProvisioningIP != null) return false;
    if (defaultMachinePlatform != null ? !defaultMachinePlatform.equals(that.defaultMachinePlatform) :that.defaultMachinePlatform != null) return false;
    if (externalBridge != null ? !externalBridge.equals(that.externalBridge) :that.externalBridge != null) return false;
    if (externalMACAddress != null ? !externalMACAddress.equals(that.externalMACAddress) :that.externalMACAddress != null) return false;
    if (hosts != null ? !hosts.equals(that.hosts) :that.hosts != null) return false;
    if (ingressVIP != null ? !ingressVIP.equals(that.ingressVIP) :that.ingressVIP != null) return false;
    if (libvirtURI != null ? !libvirtURI.equals(that.libvirtURI) :that.libvirtURI != null) return false;
    if (provisioningBridge != null ? !provisioningBridge.equals(that.provisioningBridge) :that.provisioningBridge != null) return false;
    if (provisioningDHCPExternal != null ? !provisioningDHCPExternal.equals(that.provisioningDHCPExternal) :that.provisioningDHCPExternal != null) return false;
    if (provisioningDHCPRange != null ? !provisioningDHCPRange.equals(that.provisioningDHCPRange) :that.provisioningDHCPRange != null) return false;
    if (provisioningHostIP != null ? !provisioningHostIP.equals(that.provisioningHostIP) :that.provisioningHostIP != null) return false;
    if (provisioningMACAddress != null ? !provisioningMACAddress.equals(that.provisioningMACAddress) :that.provisioningMACAddress != null) return false;
    if (provisioningNetwork != null ? !provisioningNetwork.equals(that.provisioningNetwork) :that.provisioningNetwork != null) return false;
    if (provisioningNetworkCIDR != null ? !provisioningNetworkCIDR.equals(that.provisioningNetworkCIDR) :that.provisioningNetworkCIDR != null) return false;
    if (provisioningNetworkInterface != null ? !provisioningNetworkInterface.equals(that.provisioningNetworkInterface) :that.provisioningNetworkInterface != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVIP,  bootstrapOSImage,  bootstrapProvisioningIP,  clusterOSImage,  clusterProvisioningIP,  defaultMachinePlatform,  externalBridge,  externalMACAddress,  hosts,  ingressVIP,  libvirtURI,  provisioningBridge,  provisioningDHCPExternal,  provisioningDHCPRange,  provisioningHostIP,  provisioningMACAddress,  provisioningNetwork,  provisioningNetworkCIDR,  provisioningNetworkInterface,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVIP != null) { sb.append("apiVIP:"); sb.append(apiVIP + ","); }
    if (bootstrapOSImage != null) { sb.append("bootstrapOSImage:"); sb.append(bootstrapOSImage + ","); }
    if (bootstrapProvisioningIP != null) { sb.append("bootstrapProvisioningIP:"); sb.append(bootstrapProvisioningIP + ","); }
    if (clusterOSImage != null) { sb.append("clusterOSImage:"); sb.append(clusterOSImage + ","); }
    if (clusterProvisioningIP != null) { sb.append("clusterProvisioningIP:"); sb.append(clusterProvisioningIP + ","); }
    if (defaultMachinePlatform != null) { sb.append("defaultMachinePlatform:"); sb.append(defaultMachinePlatform + ","); }
    if (externalBridge != null) { sb.append("externalBridge:"); sb.append(externalBridge + ","); }
    if (externalMACAddress != null) { sb.append("externalMACAddress:"); sb.append(externalMACAddress + ","); }
    if (hosts != null && !hosts.isEmpty()) { sb.append("hosts:"); sb.append(hosts + ","); }
    if (ingressVIP != null) { sb.append("ingressVIP:"); sb.append(ingressVIP + ","); }
    if (libvirtURI != null) { sb.append("libvirtURI:"); sb.append(libvirtURI + ","); }
    if (provisioningBridge != null) { sb.append("provisioningBridge:"); sb.append(provisioningBridge + ","); }
    if (provisioningDHCPExternal != null) { sb.append("provisioningDHCPExternal:"); sb.append(provisioningDHCPExternal + ","); }
    if (provisioningDHCPRange != null) { sb.append("provisioningDHCPRange:"); sb.append(provisioningDHCPRange + ","); }
    if (provisioningHostIP != null) { sb.append("provisioningHostIP:"); sb.append(provisioningHostIP + ","); }
    if (provisioningMACAddress != null) { sb.append("provisioningMACAddress:"); sb.append(provisioningMACAddress + ","); }
    if (provisioningNetwork != null) { sb.append("provisioningNetwork:"); sb.append(provisioningNetwork + ","); }
    if (provisioningNetworkCIDR != null) { sb.append("provisioningNetworkCIDR:"); sb.append(provisioningNetworkCIDR + ","); }
    if (provisioningNetworkInterface != null) { sb.append("provisioningNetworkInterface:"); sb.append(provisioningNetworkInterface + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withProvisioningDHCPExternal() {
    return withProvisioningDHCPExternal(true);
  }
  class DefaultMachinePlatformNestedImpl<N> extends MachinePoolFluentImpl<PlatformFluent.DefaultMachinePlatformNested<N>> implements PlatformFluent.DefaultMachinePlatformNested<N>,Nested<N>{
    DefaultMachinePlatformNestedImpl(MachinePool item) {
      this.builder = new MachinePoolBuilder(this, item);
    }
    DefaultMachinePlatformNestedImpl() {
      this.builder = new MachinePoolBuilder(this);
    }
    MachinePoolBuilder builder;
    public N and() {
      return (N) PlatformFluentImpl.this.withDefaultMachinePlatform(builder.build());
    }
    public N endDefaultMachinePlatform() {
      return and();
    }
    
  }
  class HostsNestedImpl<N> extends HostFluentImpl<PlatformFluent.HostsNested<N>> implements PlatformFluent.HostsNested<N>,Nested<N>{
    HostsNestedImpl(Integer index,Host item) {
      this.index = index;
      this.builder = new HostBuilder(this, item);
    }
    HostsNestedImpl() {
      this.index = -1;
      this.builder = new HostBuilder(this);
    }
    HostBuilder builder;
    Integer index;
    public N and() {
      return (N) PlatformFluentImpl.this.setToHosts(index,builder.build());
    }
    public N endHost() {
      return and();
    }
    
  }
  
}