package io.fabric8.openshift.api.model.installer.baremetal.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface PlatformFluent<A extends PlatformFluent<A>> extends Fluent<A>{
  public String getApiVIP();
  public A withApiVIP(String apiVIP);
  public Boolean hasApiVIP();
  public String getBootstrapOSImage();
  public A withBootstrapOSImage(String bootstrapOSImage);
  public Boolean hasBootstrapOSImage();
  public String getBootstrapProvisioningIP();
  public A withBootstrapProvisioningIP(String bootstrapProvisioningIP);
  public Boolean hasBootstrapProvisioningIP();
  public String getClusterOSImage();
  public A withClusterOSImage(String clusterOSImage);
  public Boolean hasClusterOSImage();
  public String getClusterProvisioningIP();
  public A withClusterProvisioningIP(String clusterProvisioningIP);
  public Boolean hasClusterProvisioningIP();
  
  /**
   * This method has been deprecated, please use method buildDefaultMachinePlatform instead.
   * @return The buildable object.
   */
  @Deprecated
  public MachinePool getDefaultMachinePlatform();
  public MachinePool buildDefaultMachinePlatform();
  public A withDefaultMachinePlatform(MachinePool defaultMachinePlatform);
  public Boolean hasDefaultMachinePlatform();
  public PlatformFluent.DefaultMachinePlatformNested<A> withNewDefaultMachinePlatform();
  public PlatformFluent.DefaultMachinePlatformNested<A> withNewDefaultMachinePlatformLike(MachinePool item);
  public PlatformFluent.DefaultMachinePlatformNested<A> editDefaultMachinePlatform();
  public PlatformFluent.DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatform();
  public PlatformFluent.DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatformLike(MachinePool item);
  public String getExternalBridge();
  public A withExternalBridge(String externalBridge);
  public Boolean hasExternalBridge();
  public String getExternalMACAddress();
  public A withExternalMACAddress(String externalMACAddress);
  public Boolean hasExternalMACAddress();
  public A addToHosts(Integer index,Host item);
  public A setToHosts(Integer index,Host item);
  public A addToHosts(io.fabric8.openshift.api.model.installer.baremetal.v1.Host... items);
  public A addAllToHosts(Collection<Host> items);
  public A removeFromHosts(io.fabric8.openshift.api.model.installer.baremetal.v1.Host... items);
  public A removeAllFromHosts(Collection<Host> items);
  public A removeMatchingFromHosts(Predicate<HostBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildHosts instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Host> getHosts();
  public List<Host> buildHosts();
  public Host buildHost(Integer index);
  public Host buildFirstHost();
  public Host buildLastHost();
  public Host buildMatchingHost(Predicate<HostBuilder> predicate);
  public Boolean hasMatchingHost(Predicate<HostBuilder> predicate);
  public A withHosts(List<Host> hosts);
  public A withHosts(io.fabric8.openshift.api.model.installer.baremetal.v1.Host... hosts);
  public Boolean hasHosts();
  public PlatformFluent.HostsNested<A> addNewHost();
  public PlatformFluent.HostsNested<A> addNewHostLike(Host item);
  public PlatformFluent.HostsNested<A> setNewHostLike(Integer index,Host item);
  public PlatformFluent.HostsNested<A> editHost(Integer index);
  public PlatformFluent.HostsNested<A> editFirstHost();
  public PlatformFluent.HostsNested<A> editLastHost();
  public PlatformFluent.HostsNested<A> editMatchingHost(Predicate<HostBuilder> predicate);
  public String getIngressVIP();
  public A withIngressVIP(String ingressVIP);
  public Boolean hasIngressVIP();
  public String getLibvirtURI();
  public A withLibvirtURI(String libvirtURI);
  public Boolean hasLibvirtURI();
  public String getProvisioningBridge();
  public A withProvisioningBridge(String provisioningBridge);
  public Boolean hasProvisioningBridge();
  public Boolean getProvisioningDHCPExternal();
  public A withProvisioningDHCPExternal(Boolean provisioningDHCPExternal);
  public Boolean hasProvisioningDHCPExternal();
  public String getProvisioningDHCPRange();
  public A withProvisioningDHCPRange(String provisioningDHCPRange);
  public Boolean hasProvisioningDHCPRange();
  public String getProvisioningHostIP();
  public A withProvisioningHostIP(String provisioningHostIP);
  public Boolean hasProvisioningHostIP();
  public String getProvisioningMACAddress();
  public A withProvisioningMACAddress(String provisioningMACAddress);
  public Boolean hasProvisioningMACAddress();
  public String getProvisioningNetwork();
  public A withProvisioningNetwork(String provisioningNetwork);
  public Boolean hasProvisioningNetwork();
  public String getProvisioningNetworkCIDR();
  public A withProvisioningNetworkCIDR(String provisioningNetworkCIDR);
  public Boolean hasProvisioningNetworkCIDR();
  public String getProvisioningNetworkInterface();
  public A withProvisioningNetworkInterface(String provisioningNetworkInterface);
  public Boolean hasProvisioningNetworkInterface();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public A withProvisioningDHCPExternal();
  public interface DefaultMachinePlatformNested<N> extends Nested<N>,MachinePoolFluent<PlatformFluent.DefaultMachinePlatformNested<N>>{
    public N and();
    public N endDefaultMachinePlatform();
    
  }
  public interface HostsNested<N> extends Nested<N>,HostFluent<PlatformFluent.HostsNested<N>>{
    public N and();
    public N endHost();
    
  }
  
}