package io.fabric8.openshift.api.model.installer.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class MachinePoolFluentImpl<A extends MachinePoolFluent<A>> extends BaseFluent<A> implements MachinePoolFluent<A>{
  public MachinePoolFluentImpl() {
  }
  public MachinePoolFluentImpl(MachinePool instance) {
    this.withArchitecture(instance.getArchitecture()); 
    this.withHyperthreading(instance.getHyperthreading()); 
    this.withName(instance.getName()); 
    this.withPlatform(instance.getPlatform()); 
    this.withReplicas(instance.getReplicas()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String architecture;
  private String hyperthreading;
  private String name;
  private MachinePoolPlatformBuilder platform;
  private Long replicas;
  private Map<String,Object> additionalProperties;
  public String getArchitecture() {
    return this.architecture;
  }
  public A withArchitecture(String architecture) {
    this.architecture=architecture; return (A) this;
  }
  public Boolean hasArchitecture() {
    return this.architecture != null;
  }
  public String getHyperthreading() {
    return this.hyperthreading;
  }
  public A withHyperthreading(String hyperthreading) {
    this.hyperthreading=hyperthreading; return (A) this;
  }
  public Boolean hasHyperthreading() {
    return this.hyperthreading != null;
  }
  public String getName() {
    return this.name;
  }
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  public Boolean hasName() {
    return this.name != null;
  }
  
  /**
   * This method has been deprecated, please use method buildPlatform instead.
   * @return The buildable object.
   */
  @Deprecated
  public MachinePoolPlatform getPlatform() {
    return this.platform!=null ?this.platform.build():null;
  }
  public MachinePoolPlatform buildPlatform() {
    return this.platform!=null ?this.platform.build():null;
  }
  public A withPlatform(MachinePoolPlatform platform) {
    _visitables.get("platform").remove(this.platform);
    if (platform!=null){ this.platform= new MachinePoolPlatformBuilder(platform); _visitables.get("platform").add(this.platform);} else { this.platform = null; _visitables.get("platform").remove(this.platform); } return (A) this;
  }
  public Boolean hasPlatform() {
    return this.platform != null;
  }
  public MachinePoolFluent.PlatformNested<A> withNewPlatform() {
    return new MachinePoolFluentImpl.PlatformNestedImpl();
  }
  public MachinePoolFluent.PlatformNested<A> withNewPlatformLike(MachinePoolPlatform item) {
    return new MachinePoolFluentImpl.PlatformNestedImpl(item);
  }
  public MachinePoolFluent.PlatformNested<A> editPlatform() {
    return withNewPlatformLike(getPlatform());
  }
  public MachinePoolFluent.PlatformNested<A> editOrNewPlatform() {
    return withNewPlatformLike(getPlatform() != null ? getPlatform(): new MachinePoolPlatformBuilder().build());
  }
  public MachinePoolFluent.PlatformNested<A> editOrNewPlatformLike(MachinePoolPlatform item) {
    return withNewPlatformLike(getPlatform() != null ? getPlatform(): item);
  }
  public Long getReplicas() {
    return this.replicas;
  }
  public A withReplicas(Long replicas) {
    this.replicas=replicas; return (A) this;
  }
  public Boolean hasReplicas() {
    return this.replicas != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MachinePoolFluentImpl that = (MachinePoolFluentImpl) o;
    if (architecture != null ? !architecture.equals(that.architecture) :that.architecture != null) return false;
    if (hyperthreading != null ? !hyperthreading.equals(that.hyperthreading) :that.hyperthreading != null) return false;
    if (name != null ? !name.equals(that.name) :that.name != null) return false;
    if (platform != null ? !platform.equals(that.platform) :that.platform != null) return false;
    if (replicas != null ? !replicas.equals(that.replicas) :that.replicas != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(architecture,  hyperthreading,  name,  platform,  replicas,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (architecture != null) { sb.append("architecture:"); sb.append(architecture + ","); }
    if (hyperthreading != null) { sb.append("hyperthreading:"); sb.append(hyperthreading + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (platform != null) { sb.append("platform:"); sb.append(platform + ","); }
    if (replicas != null) { sb.append("replicas:"); sb.append(replicas + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class PlatformNestedImpl<N> extends MachinePoolPlatformFluentImpl<MachinePoolFluent.PlatformNested<N>> implements MachinePoolFluent.PlatformNested<N>,Nested<N>{
    PlatformNestedImpl(MachinePoolPlatform item) {
      this.builder = new MachinePoolPlatformBuilder(this, item);
    }
    PlatformNestedImpl() {
      this.builder = new MachinePoolPlatformBuilder(this);
    }
    MachinePoolPlatformBuilder builder;
    public N and() {
      return (N) MachinePoolFluentImpl.this.withPlatform(builder.build());
    }
    public N endPlatform() {
      return and();
    }
    
  }
  
}