package io.fabric8.openshift.api.model.installer.aws.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PlatformBuilder extends PlatformFluentImpl<PlatformBuilder> implements VisitableBuilder<Platform,PlatformBuilder>{
  public PlatformBuilder() {
    this(false);
  }
  public PlatformBuilder(Boolean validationEnabled) {
    this(new Platform(), validationEnabled);
  }
  public PlatformBuilder(PlatformFluent<?> fluent) {
    this(fluent, false);
  }
  public PlatformBuilder(PlatformFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Platform(), validationEnabled);
  }
  public PlatformBuilder(PlatformFluent<?> fluent,Platform instance) {
    this(fluent, instance, false);
  }
  public PlatformBuilder(PlatformFluent<?> fluent,Platform instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAmiID(instance.getAmiID());
      fluent.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
      fluent.withExperimentalPropagateUserTags(instance.getExperimentalPropagateUserTags());
      fluent.withHostedZone(instance.getHostedZone());
      fluent.withRegion(instance.getRegion());
      fluent.withServiceEndpoints(instance.getServiceEndpoints());
      fluent.withSubnets(instance.getSubnets());
      fluent.withUserTags(instance.getUserTags());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PlatformBuilder(Platform instance) {
    this(instance,false);
  }
  public PlatformBuilder(Platform instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAmiID(instance.getAmiID());
      this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
      this.withExperimentalPropagateUserTags(instance.getExperimentalPropagateUserTags());
      this.withHostedZone(instance.getHostedZone());
      this.withRegion(instance.getRegion());
      this.withServiceEndpoints(instance.getServiceEndpoints());
      this.withSubnets(instance.getSubnets());
      this.withUserTags(instance.getUserTags());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PlatformFluent<?> fluent;
  Boolean validationEnabled;
  public Platform build() {
    Platform buildable = new Platform(fluent.getAmiID(),fluent.getDefaultMachinePlatform(),fluent.getExperimentalPropagateUserTags(),fluent.getHostedZone(),fluent.getRegion(),fluent.getServiceEndpoints(),fluent.getSubnets(),fluent.getUserTags());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}