package io.fabric8.openshift.api.model.installer.aws.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public interface PlatformFluent<A extends PlatformFluent<A>> extends Fluent<A>{
  public String getAmiID();
  public A withAmiID(String amiID);
  public Boolean hasAmiID();
  
  /**
   * This method has been deprecated, please use method buildDefaultMachinePlatform instead.
   * @return The buildable object.
   */
  @Deprecated
  public MachinePool getDefaultMachinePlatform();
  public MachinePool buildDefaultMachinePlatform();
  public A withDefaultMachinePlatform(MachinePool defaultMachinePlatform);
  public Boolean hasDefaultMachinePlatform();
  public PlatformFluent.DefaultMachinePlatformNested<A> withNewDefaultMachinePlatform();
  public PlatformFluent.DefaultMachinePlatformNested<A> withNewDefaultMachinePlatformLike(MachinePool item);
  public PlatformFluent.DefaultMachinePlatformNested<A> editDefaultMachinePlatform();
  public PlatformFluent.DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatform();
  public PlatformFluent.DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatformLike(MachinePool item);
  public Boolean getExperimentalPropagateUserTags();
  public A withExperimentalPropagateUserTags(Boolean experimentalPropagateUserTags);
  public Boolean hasExperimentalPropagateUserTags();
  public String getHostedZone();
  public A withHostedZone(String hostedZone);
  public Boolean hasHostedZone();
  public String getRegion();
  public A withRegion(String region);
  public Boolean hasRegion();
  public A addToServiceEndpoints(int index,ServiceEndpoint item);
  public A setToServiceEndpoints(int index,ServiceEndpoint item);
  public A addToServiceEndpoints(io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpoint... items);
  public A addAllToServiceEndpoints(Collection<ServiceEndpoint> items);
  public A removeFromServiceEndpoints(io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpoint... items);
  public A removeAllFromServiceEndpoints(Collection<ServiceEndpoint> items);
  public A removeMatchingFromServiceEndpoints(Predicate<ServiceEndpointBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildServiceEndpoints instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ServiceEndpoint> getServiceEndpoints();
  public List<ServiceEndpoint> buildServiceEndpoints();
  public ServiceEndpoint buildServiceEndpoint(int index);
  public ServiceEndpoint buildFirstServiceEndpoint();
  public ServiceEndpoint buildLastServiceEndpoint();
  public ServiceEndpoint buildMatchingServiceEndpoint(Predicate<ServiceEndpointBuilder> predicate);
  public Boolean hasMatchingServiceEndpoint(Predicate<ServiceEndpointBuilder> predicate);
  public A withServiceEndpoints(List<ServiceEndpoint> serviceEndpoints);
  public A withServiceEndpoints(io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpoint... serviceEndpoints);
  public Boolean hasServiceEndpoints();
  public A addNewServiceEndpoint(String name,String url);
  public PlatformFluent.ServiceEndpointsNested<A> addNewServiceEndpoint();
  public PlatformFluent.ServiceEndpointsNested<A> addNewServiceEndpointLike(ServiceEndpoint item);
  public PlatformFluent.ServiceEndpointsNested<A> setNewServiceEndpointLike(int index,ServiceEndpoint item);
  public PlatformFluent.ServiceEndpointsNested<A> editServiceEndpoint(int index);
  public PlatformFluent.ServiceEndpointsNested<A> editFirstServiceEndpoint();
  public PlatformFluent.ServiceEndpointsNested<A> editLastServiceEndpoint();
  public PlatformFluent.ServiceEndpointsNested<A> editMatchingServiceEndpoint(Predicate<ServiceEndpointBuilder> predicate);
  public A addToSubnets(int index,String item);
  public A setToSubnets(int index,String item);
  public A addToSubnets(java.lang.String... items);
  public A addAllToSubnets(Collection<String> items);
  public A removeFromSubnets(java.lang.String... items);
  public A removeAllFromSubnets(Collection<String> items);
  public List<String> getSubnets();
  public String getSubnet(int index);
  public String getFirstSubnet();
  public String getLastSubnet();
  public String getMatchingSubnet(Predicate<String> predicate);
  public Boolean hasMatchingSubnet(Predicate<String> predicate);
  public A withSubnets(List<String> subnets);
  public A withSubnets(java.lang.String... subnets);
  public Boolean hasSubnets();
  public A addToUserTags(String key,String value);
  public A addToUserTags(Map<String,String> map);
  public A removeFromUserTags(String key);
  public A removeFromUserTags(Map<String,String> map);
  public Map<String,String> getUserTags();
  public <K,V>A withUserTags(Map<String,String> userTags);
  public Boolean hasUserTags();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public A withExperimentalPropagateUserTags();
  public interface DefaultMachinePlatformNested<N> extends Nested<N>,MachinePoolFluent<PlatformFluent.DefaultMachinePlatformNested<N>>{
    public N and();
    public N endDefaultMachinePlatform();
    
  }
  public interface ServiceEndpointsNested<N> extends Nested<N>,ServiceEndpointFluent<PlatformFluent.ServiceEndpointsNested<N>>{
    public N and();
    public N endServiceEndpoint();
    
  }
  
}