package io.fabric8.openshift.api.model.installer.aws.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceEndpointBuilder extends ServiceEndpointFluentImpl<ServiceEndpointBuilder> implements VisitableBuilder<ServiceEndpoint,ServiceEndpointBuilder>{
  public ServiceEndpointBuilder() {
    this(false);
  }
  public ServiceEndpointBuilder(Boolean validationEnabled) {
    this(new ServiceEndpoint(), validationEnabled);
  }
  public ServiceEndpointBuilder(ServiceEndpointFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceEndpointBuilder(ServiceEndpointFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServiceEndpoint(), validationEnabled);
  }
  public ServiceEndpointBuilder(ServiceEndpointFluent<?> fluent,ServiceEndpoint instance) {
    this(fluent, instance, false);
  }
  public ServiceEndpointBuilder(ServiceEndpointFluent<?> fluent,ServiceEndpoint instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withUrl(instance.getUrl());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ServiceEndpointBuilder(ServiceEndpoint instance) {
    this(instance,false);
  }
  public ServiceEndpointBuilder(ServiceEndpoint instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withName(instance.getName());
      this.withUrl(instance.getUrl());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ServiceEndpointFluent<?> fluent;
  Boolean validationEnabled;
  public ServiceEndpoint build() {
    ServiceEndpoint buildable = new ServiceEndpoint(fluent.getName(),fluent.getUrl());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}