package io.fabric8.openshift.api.model.installer.azure.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OSDiskBuilder extends OSDiskFluentImpl<OSDiskBuilder> implements VisitableBuilder<OSDisk,OSDiskBuilder>{
  public OSDiskBuilder() {
    this(false);
  }
  public OSDiskBuilder(Boolean validationEnabled) {
    this(new OSDisk(), validationEnabled);
  }
  public OSDiskBuilder(OSDiskFluent<?> fluent) {
    this(fluent, false);
  }
  public OSDiskBuilder(OSDiskFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OSDisk(), validationEnabled);
  }
  public OSDiskBuilder(OSDiskFluent<?> fluent,OSDisk instance) {
    this(fluent, instance, false);
  }
  public OSDiskBuilder(OSDiskFluent<?> fluent,OSDisk instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withDiskSizeGB(instance.getDiskSizeGB());
      fluent.withDiskType(instance.getDiskType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public OSDiskBuilder(OSDisk instance) {
    this(instance,false);
  }
  public OSDiskBuilder(OSDisk instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withDiskSizeGB(instance.getDiskSizeGB());
      this.withDiskType(instance.getDiskType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  OSDiskFluent<?> fluent;
  Boolean validationEnabled;
  public OSDisk build() {
    OSDisk buildable = new OSDisk(fluent.getDiskSizeGB(),fluent.getDiskType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}