package io.fabric8.openshift.api.model.installer.baremetal.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BMCBuilder extends BMCFluentImpl<BMCBuilder> implements VisitableBuilder<BMC,BMCBuilder>{
  public BMCBuilder() {
    this(false);
  }
  public BMCBuilder(Boolean validationEnabled) {
    this(new BMC(), validationEnabled);
  }
  public BMCBuilder(BMCFluent<?> fluent) {
    this(fluent, false);
  }
  public BMCBuilder(BMCFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new BMC(), validationEnabled);
  }
  public BMCBuilder(BMCFluent<?> fluent,BMC instance) {
    this(fluent, instance, false);
  }
  public BMCBuilder(BMCFluent<?> fluent,BMC instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAddress(instance.getAddress());
      fluent.withDisableCertificateVerification(instance.getDisableCertificateVerification());
      fluent.withPassword(instance.getPassword());
      fluent.withUsername(instance.getUsername());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public BMCBuilder(BMC instance) {
    this(instance,false);
  }
  public BMCBuilder(BMC instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAddress(instance.getAddress());
      this.withDisableCertificateVerification(instance.getDisableCertificateVerification());
      this.withPassword(instance.getPassword());
      this.withUsername(instance.getUsername());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  BMCFluent<?> fluent;
  Boolean validationEnabled;
  public BMC build() {
    BMC buildable = new BMC(fluent.getAddress(),fluent.getDisableCertificateVerification(),fluent.getPassword(),fluent.getUsername());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}