package io.fabric8.openshift.api.model.installer.gcp.v1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface PlatformFluent<A extends PlatformFluent<A>> extends Fluent<A>{
  public String getComputeSubnet();
  public A withComputeSubnet(String computeSubnet);
  public Boolean hasComputeSubnet();
  public String getControlPlaneSubnet();
  public A withControlPlaneSubnet(String controlPlaneSubnet);
  public Boolean hasControlPlaneSubnet();
  
  /**
   * This method has been deprecated, please use method buildDefaultMachinePlatform instead.
   * @return The buildable object.
   */
  @Deprecated
  public MachinePool getDefaultMachinePlatform();
  public MachinePool buildDefaultMachinePlatform();
  public A withDefaultMachinePlatform(MachinePool defaultMachinePlatform);
  public Boolean hasDefaultMachinePlatform();
  public PlatformFluent.DefaultMachinePlatformNested<A> withNewDefaultMachinePlatform();
  public PlatformFluent.DefaultMachinePlatformNested<A> withNewDefaultMachinePlatformLike(MachinePool item);
  public PlatformFluent.DefaultMachinePlatformNested<A> editDefaultMachinePlatform();
  public PlatformFluent.DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatform();
  public PlatformFluent.DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatformLike(MachinePool item);
  public A addToLicenses(int index,String item);
  public A setToLicenses(int index,String item);
  public A addToLicenses(java.lang.String... items);
  public A addAllToLicenses(Collection<String> items);
  public A removeFromLicenses(java.lang.String... items);
  public A removeAllFromLicenses(Collection<String> items);
  public List<String> getLicenses();
  public String getLicense(int index);
  public String getFirstLicense();
  public String getLastLicense();
  public String getMatchingLicense(Predicate<String> predicate);
  public Boolean hasMatchingLicense(Predicate<String> predicate);
  public A withLicenses(List<String> licenses);
  public A withLicenses(java.lang.String... licenses);
  public Boolean hasLicenses();
  public String getNetwork();
  public A withNetwork(String network);
  public Boolean hasNetwork();
  public String getProjectID();
  public A withProjectID(String projectID);
  public Boolean hasProjectID();
  public String getRegion();
  public A withRegion(String region);
  public Boolean hasRegion();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface DefaultMachinePlatformNested<N> extends Nested<N>,MachinePoolFluent<PlatformFluent.DefaultMachinePlatformNested<N>>{
    public N and();
    public N endDefaultMachinePlatform();
    
  }
  
}