package io.fabric8.openshift.api.model.installer.gcp.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PlatformFluentImpl<A extends PlatformFluent<A>> extends BaseFluent<A> implements PlatformFluent<A>{
  public PlatformFluentImpl() {
  }
  public PlatformFluentImpl(Platform instance) {
    if (instance != null) {
      this.withComputeSubnet(instance.getComputeSubnet());
      this.withControlPlaneSubnet(instance.getControlPlaneSubnet());
      this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
      this.withLicenses(instance.getLicenses());
      this.withNetwork(instance.getNetwork());
      this.withProjectID(instance.getProjectID());
      this.withRegion(instance.getRegion());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String computeSubnet;
  private String controlPlaneSubnet;
  private MachinePoolBuilder defaultMachinePlatform;
  private List<String> licenses = new ArrayList<String>();
  private String network;
  private String projectID;
  private String region;
  private Map<String,Object> additionalProperties;
  public String getComputeSubnet() {
    return this.computeSubnet;
  }
  public A withComputeSubnet(String computeSubnet) {
    this.computeSubnet=computeSubnet; return (A) this;
  }
  public Boolean hasComputeSubnet() {
    return this.computeSubnet != null;
  }
  public String getControlPlaneSubnet() {
    return this.controlPlaneSubnet;
  }
  public A withControlPlaneSubnet(String controlPlaneSubnet) {
    this.controlPlaneSubnet=controlPlaneSubnet; return (A) this;
  }
  public Boolean hasControlPlaneSubnet() {
    return this.controlPlaneSubnet != null;
  }
  
  /**
   * This method has been deprecated, please use method buildDefaultMachinePlatform instead.
   * @return The buildable object.
   */
  @Deprecated
  public MachinePool getDefaultMachinePlatform() {
    return this.defaultMachinePlatform!=null ?this.defaultMachinePlatform.build():null;
  }
  public MachinePool buildDefaultMachinePlatform() {
    return this.defaultMachinePlatform!=null ?this.defaultMachinePlatform.build():null;
  }
  public A withDefaultMachinePlatform(MachinePool defaultMachinePlatform) {
    _visitables.get("defaultMachinePlatform").remove(this.defaultMachinePlatform);
    if (defaultMachinePlatform!=null){ this.defaultMachinePlatform= new MachinePoolBuilder(defaultMachinePlatform); _visitables.get("defaultMachinePlatform").add(this.defaultMachinePlatform);} else { this.defaultMachinePlatform = null; _visitables.get("defaultMachinePlatform").remove(this.defaultMachinePlatform); } return (A) this;
  }
  public Boolean hasDefaultMachinePlatform() {
    return this.defaultMachinePlatform != null;
  }
  public PlatformFluentImpl.DefaultMachinePlatformNested<A> withNewDefaultMachinePlatform() {
    return new PlatformFluentImpl.DefaultMachinePlatformNestedImpl();
  }
  public PlatformFluentImpl.DefaultMachinePlatformNested<A> withNewDefaultMachinePlatformLike(MachinePool item) {
    return new PlatformFluentImpl.DefaultMachinePlatformNestedImpl(item);
  }
  public PlatformFluentImpl.DefaultMachinePlatformNested<A> editDefaultMachinePlatform() {
    return withNewDefaultMachinePlatformLike(getDefaultMachinePlatform());
  }
  public PlatformFluentImpl.DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatform() {
    return withNewDefaultMachinePlatformLike(getDefaultMachinePlatform() != null ? getDefaultMachinePlatform(): new MachinePoolBuilder().build());
  }
  public PlatformFluentImpl.DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatformLike(MachinePool item) {
    return withNewDefaultMachinePlatformLike(getDefaultMachinePlatform() != null ? getDefaultMachinePlatform(): item);
  }
  public A addToLicenses(int index,String item) {
    if (this.licenses == null) {this.licenses = new ArrayList<String>();}
    this.licenses.add(index, item);
    return (A)this;
  }
  public A setToLicenses(int index,String item) {
    if (this.licenses == null) {this.licenses = new ArrayList<String>();}
    this.licenses.set(index, item); return (A)this;
  }
  public A addToLicenses(java.lang.String... items) {
    if (this.licenses == null) {this.licenses = new ArrayList<String>();}
    for (String item : items) {this.licenses.add(item);} return (A)this;
  }
  public A addAllToLicenses(Collection<String> items) {
    if (this.licenses == null) {this.licenses = new ArrayList<String>();}
    for (String item : items) {this.licenses.add(item);} return (A)this;
  }
  public A removeFromLicenses(java.lang.String... items) {
    for (String item : items) {if (this.licenses!= null){ this.licenses.remove(item);}} return (A)this;
  }
  public A removeAllFromLicenses(Collection<String> items) {
    for (String item : items) {if (this.licenses!= null){ this.licenses.remove(item);}} return (A)this;
  }
  public List<String> getLicenses() {
    return this.licenses;
  }
  public String getLicense(int index) {
    return this.licenses.get(index);
  }
  public String getFirstLicense() {
    return this.licenses.get(0);
  }
  public String getLastLicense() {
    return this.licenses.get(licenses.size() - 1);
  }
  public String getMatchingLicense(Predicate<String> predicate) {
    for (String item: licenses) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingLicense(Predicate<String> predicate) {
    for (String item: licenses) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withLicenses(List<String> licenses) {
    if (licenses != null) {this.licenses = new ArrayList(); for (String item : licenses){this.addToLicenses(item);}} else { this.licenses = null;} return (A) this;
  }
  public A withLicenses(java.lang.String... licenses) {
    if (this.licenses != null) {this.licenses.clear(); _visitables.remove("licenses"); }
    if (licenses != null) {for (String item :licenses){ this.addToLicenses(item);}} return (A) this;
  }
  public Boolean hasLicenses() {
    return licenses != null && !licenses.isEmpty();
  }
  public String getNetwork() {
    return this.network;
  }
  public A withNetwork(String network) {
    this.network=network; return (A) this;
  }
  public Boolean hasNetwork() {
    return this.network != null;
  }
  public String getProjectID() {
    return this.projectID;
  }
  public A withProjectID(String projectID) {
    this.projectID=projectID; return (A) this;
  }
  public Boolean hasProjectID() {
    return this.projectID != null;
  }
  public String getRegion() {
    return this.region;
  }
  public A withRegion(String region) {
    this.region=region; return (A) this;
  }
  public Boolean hasRegion() {
    return this.region != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PlatformFluentImpl that = (PlatformFluentImpl) o;
    if (!java.util.Objects.equals(computeSubnet, that.computeSubnet)) return false;

    if (!java.util.Objects.equals(controlPlaneSubnet, that.controlPlaneSubnet)) return false;

    if (!java.util.Objects.equals(defaultMachinePlatform, that.defaultMachinePlatform)) return false;

    if (!java.util.Objects.equals(licenses, that.licenses)) return false;

    if (!java.util.Objects.equals(network, that.network)) return false;

    if (!java.util.Objects.equals(projectID, that.projectID)) return false;

    if (!java.util.Objects.equals(region, that.region)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(computeSubnet,  controlPlaneSubnet,  defaultMachinePlatform,  licenses,  network,  projectID,  region,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (computeSubnet != null) { sb.append("computeSubnet:"); sb.append(computeSubnet + ","); }
    if (controlPlaneSubnet != null) { sb.append("controlPlaneSubnet:"); sb.append(controlPlaneSubnet + ","); }
    if (defaultMachinePlatform != null) { sb.append("defaultMachinePlatform:"); sb.append(defaultMachinePlatform + ","); }
    if (licenses != null && !licenses.isEmpty()) { sb.append("licenses:"); sb.append(licenses + ","); }
    if (network != null) { sb.append("network:"); sb.append(network + ","); }
    if (projectID != null) { sb.append("projectID:"); sb.append(projectID + ","); }
    if (region != null) { sb.append("region:"); sb.append(region + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class DefaultMachinePlatformNestedImpl<N> extends MachinePoolFluentImpl<PlatformFluentImpl.DefaultMachinePlatformNested<N>> implements PlatformFluentImpl.DefaultMachinePlatformNested<N>,Nested<N>{
    DefaultMachinePlatformNestedImpl(MachinePool item) {
      this.builder = new MachinePoolBuilder(this, item);
    }
    DefaultMachinePlatformNestedImpl() {
      this.builder = new MachinePoolBuilder(this);
    }
    MachinePoolBuilder builder;
    public N and() {
      return (N) PlatformFluentImpl.this.withDefaultMachinePlatform(builder.build());
    }
    public N endDefaultMachinePlatform() {
      return and();
    }
    
  }
  
}