package io.fabric8.openshift.api.model.installer.openstack.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PlatformBuilder extends PlatformFluentImpl<PlatformBuilder> implements VisitableBuilder<Platform,PlatformBuilder>{
  public PlatformBuilder() {
    this(false);
  }
  public PlatformBuilder(Boolean validationEnabled) {
    this(new Platform(), validationEnabled);
  }
  public PlatformBuilder(PlatformFluent<?> fluent) {
    this(fluent, false);
  }
  public PlatformBuilder(PlatformFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Platform(), validationEnabled);
  }
  public PlatformBuilder(PlatformFluent<?> fluent,Platform instance) {
    this(fluent, instance, false);
  }
  public PlatformBuilder(PlatformFluent<?> fluent,Platform instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiFloatingIP(instance.getApiFloatingIP());
      fluent.withApiVIP(instance.getApiVIP());
      fluent.withCloud(instance.getCloud());
      fluent.withClusterOSImage(instance.getClusterOSImage());
      fluent.withClusterOSImageProperties(instance.getClusterOSImageProperties());
      fluent.withComputeFlavor(instance.getComputeFlavor());
      fluent.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
      fluent.withExternalDNS(instance.getExternalDNS());
      fluent.withExternalNetwork(instance.getExternalNetwork());
      fluent.withIngressFloatingIP(instance.getIngressFloatingIP());
      fluent.withIngressVIP(instance.getIngressVIP());
      fluent.withLbFloatingIP(instance.getLbFloatingIP());
      fluent.withMachinesSubnet(instance.getMachinesSubnet());
      fluent.withOctaviaSupport(instance.getOctaviaSupport());
      fluent.withRegion(instance.getRegion());
      fluent.withTrunkSupport(instance.getTrunkSupport());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PlatformBuilder(Platform instance) {
    this(instance,false);
  }
  public PlatformBuilder(Platform instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiFloatingIP(instance.getApiFloatingIP());
      this.withApiVIP(instance.getApiVIP());
      this.withCloud(instance.getCloud());
      this.withClusterOSImage(instance.getClusterOSImage());
      this.withClusterOSImageProperties(instance.getClusterOSImageProperties());
      this.withComputeFlavor(instance.getComputeFlavor());
      this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
      this.withExternalDNS(instance.getExternalDNS());
      this.withExternalNetwork(instance.getExternalNetwork());
      this.withIngressFloatingIP(instance.getIngressFloatingIP());
      this.withIngressVIP(instance.getIngressVIP());
      this.withLbFloatingIP(instance.getLbFloatingIP());
      this.withMachinesSubnet(instance.getMachinesSubnet());
      this.withOctaviaSupport(instance.getOctaviaSupport());
      this.withRegion(instance.getRegion());
      this.withTrunkSupport(instance.getTrunkSupport());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PlatformFluent<?> fluent;
  Boolean validationEnabled;
  public Platform build() {
    Platform buildable = new Platform(fluent.getApiFloatingIP(),fluent.getApiVIP(),fluent.getCloud(),fluent.getClusterOSImage(),fluent.getClusterOSImageProperties(),fluent.getComputeFlavor(),fluent.getDefaultMachinePlatform(),fluent.getExternalDNS(),fluent.getExternalNetwork(),fluent.getIngressFloatingIP(),fluent.getIngressVIP(),fluent.getLbFloatingIP(),fluent.getMachinesSubnet(),fluent.getOctaviaSupport(),fluent.getRegion(),fluent.getTrunkSupport());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}