package io.fabric8.openshift.api.model.installer.ovirt.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DiskBuilder extends DiskFluentImpl<DiskBuilder> implements VisitableBuilder<Disk,DiskBuilder>{
  public DiskBuilder() {
    this(false);
  }
  public DiskBuilder(Boolean validationEnabled) {
    this(new Disk(), validationEnabled);
  }
  public DiskBuilder(DiskFluent<?> fluent) {
    this(fluent, false);
  }
  public DiskBuilder(DiskFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Disk(), validationEnabled);
  }
  public DiskBuilder(DiskFluent<?> fluent,Disk instance) {
    this(fluent, instance, false);
  }
  public DiskBuilder(DiskFluent<?> fluent,Disk instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withSizeGB(instance.getSizeGB());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DiskBuilder(Disk instance) {
    this(instance,false);
  }
  public DiskBuilder(Disk instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withSizeGB(instance.getSizeGB());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  DiskFluent<?> fluent;
  Boolean validationEnabled;
  public Disk build() {
    Disk buildable = new Disk(fluent.getSizeGB());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}