package io.fabric8.openshift.api.model.installer.ovirt.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PlatformFluentImpl<A extends PlatformFluent<A>> extends BaseFluent<A> implements PlatformFluent<A>{
  public PlatformFluentImpl() {
  }
  public PlatformFluentImpl(Platform instance) {
    if (instance != null) {
      this.withAffinityGroups(instance.getAffinityGroups());
      this.withApiVip(instance.getApiVip());
      this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
      this.withIngressVip(instance.getIngressVip());
      this.withOvirtClusterId(instance.getOvirtClusterId());
      this.withOvirtNetworkName(instance.getOvirtNetworkName());
      this.withOvirtStorageDomainId(instance.getOvirtStorageDomainId());
      this.withVnicProfileID(instance.getVnicProfileID());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private ArrayList<AffinityGroupBuilder> affinityGroups = new ArrayList<AffinityGroupBuilder>();
  private String apiVip;
  private MachinePoolBuilder defaultMachinePlatform;
  private String ingressVip;
  private String ovirtClusterId;
  private String ovirtNetworkName;
  private String ovirtStorageDomainId;
  private String vnicProfileID;
  private Map<String,Object> additionalProperties;
  public A addToAffinityGroups(int index,AffinityGroup item) {
    if (this.affinityGroups == null) {this.affinityGroups = new ArrayList<AffinityGroupBuilder>();}
    AffinityGroupBuilder builder = new AffinityGroupBuilder(item);
    if (index < 0 || index >= affinityGroups.size()) { _visitables.get("affinityGroups").add(builder); affinityGroups.add(builder); } else { _visitables.get("affinityGroups").add(index, builder); affinityGroups.add(index, builder);}
    return (A)this;
  }
  public A setToAffinityGroups(int index,AffinityGroup item) {
    if (this.affinityGroups == null) {this.affinityGroups = new ArrayList<AffinityGroupBuilder>();}
    AffinityGroupBuilder builder = new AffinityGroupBuilder(item);
    if (index < 0 || index >= affinityGroups.size()) { _visitables.get("affinityGroups").add(builder); affinityGroups.add(builder); } else { _visitables.get("affinityGroups").set(index, builder); affinityGroups.set(index, builder);}
    return (A)this;
  }
  public A addToAffinityGroups(io.fabric8.openshift.api.model.installer.ovirt.v1.AffinityGroup... items) {
    if (this.affinityGroups == null) {this.affinityGroups = new ArrayList<AffinityGroupBuilder>();}
    for (AffinityGroup item : items) {AffinityGroupBuilder builder = new AffinityGroupBuilder(item);_visitables.get("affinityGroups").add(builder);this.affinityGroups.add(builder);} return (A)this;
  }
  public A addAllToAffinityGroups(Collection<AffinityGroup> items) {
    if (this.affinityGroups == null) {this.affinityGroups = new ArrayList<AffinityGroupBuilder>();}
    for (AffinityGroup item : items) {AffinityGroupBuilder builder = new AffinityGroupBuilder(item);_visitables.get("affinityGroups").add(builder);this.affinityGroups.add(builder);} return (A)this;
  }
  public A removeFromAffinityGroups(io.fabric8.openshift.api.model.installer.ovirt.v1.AffinityGroup... items) {
    for (AffinityGroup item : items) {AffinityGroupBuilder builder = new AffinityGroupBuilder(item);_visitables.get("affinityGroups").remove(builder);if (this.affinityGroups != null) {this.affinityGroups.remove(builder);}} return (A)this;
  }
  public A removeAllFromAffinityGroups(Collection<AffinityGroup> items) {
    for (AffinityGroup item : items) {AffinityGroupBuilder builder = new AffinityGroupBuilder(item);_visitables.get("affinityGroups").remove(builder);if (this.affinityGroups != null) {this.affinityGroups.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromAffinityGroups(Predicate<AffinityGroupBuilder> predicate) {
    if (affinityGroups == null) return (A) this;
    final Iterator<AffinityGroupBuilder> each = affinityGroups.iterator();
    final List visitables = _visitables.get("affinityGroups");
    while (each.hasNext()) {
      AffinityGroupBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildAffinityGroups instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<AffinityGroup> getAffinityGroups() {
    return affinityGroups != null ? build(affinityGroups) : null;
  }
  public List<AffinityGroup> buildAffinityGroups() {
    return affinityGroups != null ? build(affinityGroups) : null;
  }
  public AffinityGroup buildAffinityGroup(int index) {
    return this.affinityGroups.get(index).build();
  }
  public AffinityGroup buildFirstAffinityGroup() {
    return this.affinityGroups.get(0).build();
  }
  public AffinityGroup buildLastAffinityGroup() {
    return this.affinityGroups.get(affinityGroups.size() - 1).build();
  }
  public AffinityGroup buildMatchingAffinityGroup(Predicate<AffinityGroupBuilder> predicate) {
    for (AffinityGroupBuilder item: affinityGroups) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingAffinityGroup(Predicate<AffinityGroupBuilder> predicate) {
    for (AffinityGroupBuilder item: affinityGroups) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAffinityGroups(List<AffinityGroup> affinityGroups) {
    if (this.affinityGroups != null) { _visitables.get("affinityGroups").clear();}
    if (affinityGroups != null) {this.affinityGroups = new ArrayList(); for (AffinityGroup item : affinityGroups){this.addToAffinityGroups(item);}} else { this.affinityGroups = null;} return (A) this;
  }
  public A withAffinityGroups(io.fabric8.openshift.api.model.installer.ovirt.v1.AffinityGroup... affinityGroups) {
    if (this.affinityGroups != null) {this.affinityGroups.clear(); _visitables.remove("affinityGroups"); }
    if (affinityGroups != null) {for (AffinityGroup item :affinityGroups){ this.addToAffinityGroups(item);}} return (A) this;
  }
  public Boolean hasAffinityGroups() {
    return affinityGroups != null && !affinityGroups.isEmpty();
  }
  public A addNewAffinityGroup(String description,Boolean enforcing,String name,Integer priority) {
    return (A)addToAffinityGroups(new AffinityGroup(description, enforcing, name, priority));
  }
  public PlatformFluentImpl.AffinityGroupsNested<A> addNewAffinityGroup() {
    return new PlatformFluentImpl.AffinityGroupsNestedImpl();
  }
  public PlatformFluentImpl.AffinityGroupsNested<A> addNewAffinityGroupLike(AffinityGroup item) {
    return new PlatformFluentImpl.AffinityGroupsNestedImpl(-1, item);
  }
  public PlatformFluentImpl.AffinityGroupsNested<A> setNewAffinityGroupLike(int index,AffinityGroup item) {
    return new PlatformFluentImpl.AffinityGroupsNestedImpl(index, item);
  }
  public PlatformFluentImpl.AffinityGroupsNested<A> editAffinityGroup(int index) {
    if (affinityGroups.size() <= index) throw new RuntimeException("Can't edit affinityGroups. Index exceeds size.");
    return setNewAffinityGroupLike(index, buildAffinityGroup(index));
  }
  public PlatformFluentImpl.AffinityGroupsNested<A> editFirstAffinityGroup() {
    if (affinityGroups.size() == 0) throw new RuntimeException("Can't edit first affinityGroups. The list is empty.");
    return setNewAffinityGroupLike(0, buildAffinityGroup(0));
  }
  public PlatformFluentImpl.AffinityGroupsNested<A> editLastAffinityGroup() {
    int index = affinityGroups.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last affinityGroups. The list is empty.");
    return setNewAffinityGroupLike(index, buildAffinityGroup(index));
  }
  public PlatformFluentImpl.AffinityGroupsNested<A> editMatchingAffinityGroup(Predicate<AffinityGroupBuilder> predicate) {
    int index = -1;
    for (int i=0;i<affinityGroups.size();i++) { 
    if (predicate.test(affinityGroups.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching affinityGroups. No match found.");
    return setNewAffinityGroupLike(index, buildAffinityGroup(index));
  }
  public String getApiVip() {
    return this.apiVip;
  }
  public A withApiVip(String apiVip) {
    this.apiVip=apiVip; return (A) this;
  }
  public Boolean hasApiVip() {
    return this.apiVip != null;
  }
  
  /**
   * This method has been deprecated, please use method buildDefaultMachinePlatform instead.
   * @return The buildable object.
   */
  @Deprecated
  public MachinePool getDefaultMachinePlatform() {
    return this.defaultMachinePlatform!=null ?this.defaultMachinePlatform.build():null;
  }
  public MachinePool buildDefaultMachinePlatform() {
    return this.defaultMachinePlatform!=null ?this.defaultMachinePlatform.build():null;
  }
  public A withDefaultMachinePlatform(MachinePool defaultMachinePlatform) {
    _visitables.get("defaultMachinePlatform").remove(this.defaultMachinePlatform);
    if (defaultMachinePlatform!=null){ this.defaultMachinePlatform= new MachinePoolBuilder(defaultMachinePlatform); _visitables.get("defaultMachinePlatform").add(this.defaultMachinePlatform);} else { this.defaultMachinePlatform = null; _visitables.get("defaultMachinePlatform").remove(this.defaultMachinePlatform); } return (A) this;
  }
  public Boolean hasDefaultMachinePlatform() {
    return this.defaultMachinePlatform != null;
  }
  public PlatformFluentImpl.DefaultMachinePlatformNested<A> withNewDefaultMachinePlatform() {
    return new PlatformFluentImpl.DefaultMachinePlatformNestedImpl();
  }
  public PlatformFluentImpl.DefaultMachinePlatformNested<A> withNewDefaultMachinePlatformLike(MachinePool item) {
    return new PlatformFluentImpl.DefaultMachinePlatformNestedImpl(item);
  }
  public PlatformFluentImpl.DefaultMachinePlatformNested<A> editDefaultMachinePlatform() {
    return withNewDefaultMachinePlatformLike(getDefaultMachinePlatform());
  }
  public PlatformFluentImpl.DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatform() {
    return withNewDefaultMachinePlatformLike(getDefaultMachinePlatform() != null ? getDefaultMachinePlatform(): new MachinePoolBuilder().build());
  }
  public PlatformFluentImpl.DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatformLike(MachinePool item) {
    return withNewDefaultMachinePlatformLike(getDefaultMachinePlatform() != null ? getDefaultMachinePlatform(): item);
  }
  public String getIngressVip() {
    return this.ingressVip;
  }
  public A withIngressVip(String ingressVip) {
    this.ingressVip=ingressVip; return (A) this;
  }
  public Boolean hasIngressVip() {
    return this.ingressVip != null;
  }
  public String getOvirtClusterId() {
    return this.ovirtClusterId;
  }
  public A withOvirtClusterId(String ovirtClusterId) {
    this.ovirtClusterId=ovirtClusterId; return (A) this;
  }
  public Boolean hasOvirtClusterId() {
    return this.ovirtClusterId != null;
  }
  public String getOvirtNetworkName() {
    return this.ovirtNetworkName;
  }
  public A withOvirtNetworkName(String ovirtNetworkName) {
    this.ovirtNetworkName=ovirtNetworkName; return (A) this;
  }
  public Boolean hasOvirtNetworkName() {
    return this.ovirtNetworkName != null;
  }
  public String getOvirtStorageDomainId() {
    return this.ovirtStorageDomainId;
  }
  public A withOvirtStorageDomainId(String ovirtStorageDomainId) {
    this.ovirtStorageDomainId=ovirtStorageDomainId; return (A) this;
  }
  public Boolean hasOvirtStorageDomainId() {
    return this.ovirtStorageDomainId != null;
  }
  public String getVnicProfileID() {
    return this.vnicProfileID;
  }
  public A withVnicProfileID(String vnicProfileID) {
    this.vnicProfileID=vnicProfileID; return (A) this;
  }
  public Boolean hasVnicProfileID() {
    return this.vnicProfileID != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PlatformFluentImpl that = (PlatformFluentImpl) o;
    if (!java.util.Objects.equals(affinityGroups, that.affinityGroups)) return false;

    if (!java.util.Objects.equals(apiVip, that.apiVip)) return false;

    if (!java.util.Objects.equals(defaultMachinePlatform, that.defaultMachinePlatform)) return false;

    if (!java.util.Objects.equals(ingressVip, that.ingressVip)) return false;

    if (!java.util.Objects.equals(ovirtClusterId, that.ovirtClusterId)) return false;

    if (!java.util.Objects.equals(ovirtNetworkName, that.ovirtNetworkName)) return false;

    if (!java.util.Objects.equals(ovirtStorageDomainId, that.ovirtStorageDomainId)) return false;

    if (!java.util.Objects.equals(vnicProfileID, that.vnicProfileID)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(affinityGroups,  apiVip,  defaultMachinePlatform,  ingressVip,  ovirtClusterId,  ovirtNetworkName,  ovirtStorageDomainId,  vnicProfileID,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (affinityGroups != null) { sb.append("affinityGroups:"); sb.append(affinityGroups + ","); }
    if (apiVip != null) { sb.append("apiVip:"); sb.append(apiVip + ","); }
    if (defaultMachinePlatform != null) { sb.append("defaultMachinePlatform:"); sb.append(defaultMachinePlatform + ","); }
    if (ingressVip != null) { sb.append("ingressVip:"); sb.append(ingressVip + ","); }
    if (ovirtClusterId != null) { sb.append("ovirtClusterId:"); sb.append(ovirtClusterId + ","); }
    if (ovirtNetworkName != null) { sb.append("ovirtNetworkName:"); sb.append(ovirtNetworkName + ","); }
    if (ovirtStorageDomainId != null) { sb.append("ovirtStorageDomainId:"); sb.append(ovirtStorageDomainId + ","); }
    if (vnicProfileID != null) { sb.append("vnicProfileID:"); sb.append(vnicProfileID + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class AffinityGroupsNestedImpl<N> extends AffinityGroupFluentImpl<PlatformFluentImpl.AffinityGroupsNested<N>> implements PlatformFluentImpl.AffinityGroupsNested<N>,Nested<N>{
    AffinityGroupsNestedImpl(int index,AffinityGroup item) {
      this.index = index;
      this.builder = new AffinityGroupBuilder(this, item);
    }
    AffinityGroupsNestedImpl() {
      this.index = -1;
      this.builder = new AffinityGroupBuilder(this);
    }
    AffinityGroupBuilder builder;
    int index;
    public N and() {
      return (N) PlatformFluentImpl.this.setToAffinityGroups(index,builder.build());
    }
    public N endAffinityGroup() {
      return and();
    }
    
  }
  class DefaultMachinePlatformNestedImpl<N> extends MachinePoolFluentImpl<PlatformFluentImpl.DefaultMachinePlatformNested<N>> implements PlatformFluentImpl.DefaultMachinePlatformNested<N>,Nested<N>{
    DefaultMachinePlatformNestedImpl(MachinePool item) {
      this.builder = new MachinePoolBuilder(this, item);
    }
    DefaultMachinePlatformNestedImpl() {
      this.builder = new MachinePoolBuilder(this);
    }
    MachinePoolBuilder builder;
    public N and() {
      return (N) PlatformFluentImpl.this.withDefaultMachinePlatform(builder.build());
    }
    public N endDefaultMachinePlatform() {
      return and();
    }
    
  }
  
}