package io.fabric8.openshift.api.model.installer.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BootstrapInPlaceBuilder extends BootstrapInPlaceFluentImpl<BootstrapInPlaceBuilder> implements VisitableBuilder<BootstrapInPlace,BootstrapInPlaceBuilder>{
  public BootstrapInPlaceBuilder() {
    this(false);
  }
  public BootstrapInPlaceBuilder(Boolean validationEnabled) {
    this(new BootstrapInPlace(), validationEnabled);
  }
  public BootstrapInPlaceBuilder(BootstrapInPlaceFluent<?> fluent) {
    this(fluent, false);
  }
  public BootstrapInPlaceBuilder(BootstrapInPlaceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new BootstrapInPlace(), validationEnabled);
  }
  public BootstrapInPlaceBuilder(BootstrapInPlaceFluent<?> fluent,BootstrapInPlace instance) {
    this(fluent, instance, false);
  }
  public BootstrapInPlaceBuilder(BootstrapInPlaceFluent<?> fluent,BootstrapInPlace instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withInstallationDisk(instance.getInstallationDisk());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public BootstrapInPlaceBuilder(BootstrapInPlace instance) {
    this(instance,false);
  }
  public BootstrapInPlaceBuilder(BootstrapInPlace instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withInstallationDisk(instance.getInstallationDisk());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  BootstrapInPlaceFluent<?> fluent;
  Boolean validationEnabled;
  public BootstrapInPlace build() {
    BootstrapInPlace buildable = new BootstrapInPlace(fluent.getInstallationDisk());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}