package io.fabric8.openshift.api.model.installer.aws.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EC2MetadataBuilder extends EC2MetadataFluent<EC2MetadataBuilder> implements VisitableBuilder<EC2Metadata,EC2MetadataBuilder>{
  public EC2MetadataBuilder() {
    this(false);
  }
  public EC2MetadataBuilder(Boolean validationEnabled) {
    this(new EC2Metadata(), validationEnabled);
  }
  public EC2MetadataBuilder(EC2MetadataFluent<?> fluent) {
    this(fluent, false);
  }
  public EC2MetadataBuilder(EC2MetadataFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EC2Metadata(), validationEnabled);
  }
  public EC2MetadataBuilder(EC2MetadataFluent<?> fluent,EC2Metadata instance) {
    this(fluent, instance, false);
  }
  public EC2MetadataBuilder(EC2MetadataFluent<?> fluent,EC2Metadata instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new EC2Metadata());

    if (instance != null) {
      fluent.withAuthentication(instance.getAuthentication());
      fluent.withAuthentication(instance.getAuthentication());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public EC2MetadataBuilder(EC2Metadata instance) {
    this(instance,false);
  }
  public EC2MetadataBuilder(EC2Metadata instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new EC2Metadata());

    if (instance != null) {
      this.withAuthentication(instance.getAuthentication());
      this.withAuthentication(instance.getAuthentication());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  EC2MetadataFluent<?> fluent;
  Boolean validationEnabled;
  public EC2Metadata build() {
    EC2Metadata buildable = new EC2Metadata(fluent.getAuthentication());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}