package io.fabric8.openshift.api.model.installer.aws.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PlatformBuilder extends PlatformFluent<PlatformBuilder> implements VisitableBuilder<Platform,PlatformBuilder>{
  public PlatformBuilder() {
    this(false);
  }
  public PlatformBuilder(Boolean validationEnabled) {
    this(new Platform(), validationEnabled);
  }
  public PlatformBuilder(PlatformFluent<?> fluent) {
    this(fluent, false);
  }
  public PlatformBuilder(PlatformFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Platform(), validationEnabled);
  }
  public PlatformBuilder(PlatformFluent<?> fluent,Platform instance) {
    this(fluent, instance, false);
  }
  public PlatformBuilder(PlatformFluent<?> fluent,Platform instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Platform());

    if (instance != null) {
      fluent.withAmiID(instance.getAmiID());
      fluent.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
      fluent.withExperimentalPropagateUserTags(instance.getExperimentalPropagateUserTags());
      fluent.withHostedZone(instance.getHostedZone());
      fluent.withLbType(instance.getLbType());
      fluent.withPropagateUserTags(instance.getPropagateUserTags());
      fluent.withRegion(instance.getRegion());
      fluent.withServiceEndpoints(instance.getServiceEndpoints());
      fluent.withSubnets(instance.getSubnets());
      fluent.withUserTags(instance.getUserTags());
      fluent.withAmiID(instance.getAmiID());
      fluent.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
      fluent.withExperimentalPropagateUserTags(instance.getExperimentalPropagateUserTags());
      fluent.withHostedZone(instance.getHostedZone());
      fluent.withLbType(instance.getLbType());
      fluent.withPropagateUserTags(instance.getPropagateUserTags());
      fluent.withRegion(instance.getRegion());
      fluent.withServiceEndpoints(instance.getServiceEndpoints());
      fluent.withSubnets(instance.getSubnets());
      fluent.withUserTags(instance.getUserTags());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PlatformBuilder(Platform instance) {
    this(instance,false);
  }
  public PlatformBuilder(Platform instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Platform());

    if (instance != null) {
      this.withAmiID(instance.getAmiID());
      this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
      this.withExperimentalPropagateUserTags(instance.getExperimentalPropagateUserTags());
      this.withHostedZone(instance.getHostedZone());
      this.withLbType(instance.getLbType());
      this.withPropagateUserTags(instance.getPropagateUserTags());
      this.withRegion(instance.getRegion());
      this.withServiceEndpoints(instance.getServiceEndpoints());
      this.withSubnets(instance.getSubnets());
      this.withUserTags(instance.getUserTags());
      this.withAmiID(instance.getAmiID());
      this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
      this.withExperimentalPropagateUserTags(instance.getExperimentalPropagateUserTags());
      this.withHostedZone(instance.getHostedZone());
      this.withLbType(instance.getLbType());
      this.withPropagateUserTags(instance.getPropagateUserTags());
      this.withRegion(instance.getRegion());
      this.withServiceEndpoints(instance.getServiceEndpoints());
      this.withSubnets(instance.getSubnets());
      this.withUserTags(instance.getUserTags());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PlatformFluent<?> fluent;
  Boolean validationEnabled;
  public Platform build() {
    Platform buildable = new Platform(fluent.getAmiID(),fluent.buildDefaultMachinePlatform(),fluent.getExperimentalPropagateUserTags(),fluent.getHostedZone(),fluent.getLbType(),fluent.getPropagateUserTags(),fluent.getRegion(),fluent.buildServiceEndpoints(),fluent.getSubnets(),fluent.getUserTags());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}