package io.fabric8.openshift.api.model.installer.azure.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OSImageBuilder extends OSImageFluent<OSImageBuilder> implements VisitableBuilder<OSImage,OSImageBuilder>{
  public OSImageBuilder() {
    this(false);
  }
  public OSImageBuilder(Boolean validationEnabled) {
    this(new OSImage(), validationEnabled);
  }
  public OSImageBuilder(OSImageFluent<?> fluent) {
    this(fluent, false);
  }
  public OSImageBuilder(OSImageFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OSImage(), validationEnabled);
  }
  public OSImageBuilder(OSImageFluent<?> fluent,OSImage instance) {
    this(fluent, instance, false);
  }
  public OSImageBuilder(OSImageFluent<?> fluent,OSImage instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new OSImage());

    if (instance != null) {
      fluent.withOffer(instance.getOffer());
      fluent.withPublisher(instance.getPublisher());
      fluent.withSku(instance.getSku());
      fluent.withVersion(instance.getVersion());
      fluent.withOffer(instance.getOffer());
      fluent.withPublisher(instance.getPublisher());
      fluent.withSku(instance.getSku());
      fluent.withVersion(instance.getVersion());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public OSImageBuilder(OSImage instance) {
    this(instance,false);
  }
  public OSImageBuilder(OSImage instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new OSImage());

    if (instance != null) {
      this.withOffer(instance.getOffer());
      this.withPublisher(instance.getPublisher());
      this.withSku(instance.getSku());
      this.withVersion(instance.getVersion());
      this.withOffer(instance.getOffer());
      this.withPublisher(instance.getPublisher());
      this.withSku(instance.getSku());
      this.withVersion(instance.getVersion());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  OSImageFluent<?> fluent;
  Boolean validationEnabled;
  public OSImage build() {
    OSImage buildable = new OSImage(fluent.getOffer(),fluent.getPublisher(),fluent.getSku(),fluent.getVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}