package io.fabric8.openshift.api.model.installer.gcp.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MachinePoolBuilder extends MachinePoolFluent<MachinePoolBuilder> implements VisitableBuilder<MachinePool,MachinePoolBuilder>{
  public MachinePoolBuilder() {
    this(false);
  }
  public MachinePoolBuilder(Boolean validationEnabled) {
    this(new MachinePool(), validationEnabled);
  }
  public MachinePoolBuilder(MachinePoolFluent<?> fluent) {
    this(fluent, false);
  }
  public MachinePoolBuilder(MachinePoolFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MachinePool(), validationEnabled);
  }
  public MachinePoolBuilder(MachinePoolFluent<?> fluent,MachinePool instance) {
    this(fluent, instance, false);
  }
  public MachinePoolBuilder(MachinePoolFluent<?> fluent,MachinePool instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new MachinePool());

    if (instance != null) {
      fluent.withConfidentialCompute(instance.getConfidentialCompute());
      fluent.withOnHostMaintenance(instance.getOnHostMaintenance());
      fluent.withOsDisk(instance.getOsDisk());
      fluent.withSecureBoot(instance.getSecureBoot());
      fluent.withTags(instance.getTags());
      fluent.withType(instance.getType());
      fluent.withZones(instance.getZones());
      fluent.withConfidentialCompute(instance.getConfidentialCompute());
      fluent.withOnHostMaintenance(instance.getOnHostMaintenance());
      fluent.withOsDisk(instance.getOsDisk());
      fluent.withSecureBoot(instance.getSecureBoot());
      fluent.withTags(instance.getTags());
      fluent.withType(instance.getType());
      fluent.withZones(instance.getZones());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public MachinePoolBuilder(MachinePool instance) {
    this(instance,false);
  }
  public MachinePoolBuilder(MachinePool instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new MachinePool());

    if (instance != null) {
      this.withConfidentialCompute(instance.getConfidentialCompute());
      this.withOnHostMaintenance(instance.getOnHostMaintenance());
      this.withOsDisk(instance.getOsDisk());
      this.withSecureBoot(instance.getSecureBoot());
      this.withTags(instance.getTags());
      this.withType(instance.getType());
      this.withZones(instance.getZones());
      this.withConfidentialCompute(instance.getConfidentialCompute());
      this.withOnHostMaintenance(instance.getOnHostMaintenance());
      this.withOsDisk(instance.getOsDisk());
      this.withSecureBoot(instance.getSecureBoot());
      this.withTags(instance.getTags());
      this.withType(instance.getType());
      this.withZones(instance.getZones());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  MachinePoolFluent<?> fluent;
  Boolean validationEnabled;
  public MachinePool build() {
    MachinePool buildable = new MachinePool(fluent.getConfidentialCompute(),fluent.getOnHostMaintenance(),fluent.buildOsDisk(),fluent.getSecureBoot(),fluent.getTags(),fluent.getType(),fluent.getZones());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}