package io.fabric8.openshift.api.model.installer.ibmcloud.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class MachinePoolFluent<A extends MachinePoolFluent<A>> extends BaseFluent<A>{
  public MachinePoolFluent() {
  }
  public MachinePoolFluent(MachinePool instance) {
    instance = (instance != null ? instance : new MachinePool());

    if (instance != null) {
      this.withBootVolume(instance.getBootVolume());
      this.withDedicatedHosts(instance.getDedicatedHosts());
      this.withType(instance.getType());
      this.withZones(instance.getZones());
      this.withBootVolume(instance.getBootVolume());
      this.withDedicatedHosts(instance.getDedicatedHosts());
      this.withType(instance.getType());
      this.withZones(instance.getZones());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private BootVolumeBuilder bootVolume;
  private ArrayList<DedicatedHostBuilder> dedicatedHosts = new ArrayList<DedicatedHostBuilder>();
  private String type;
  private List<String> zones = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  public BootVolume buildBootVolume() {
    return this.bootVolume!=null ?this.bootVolume.build():null;
  }
  public A withBootVolume(BootVolume bootVolume) {
    _visitables.get("bootVolume").remove(this.bootVolume);
    if (bootVolume!=null){ this.bootVolume= new BootVolumeBuilder(bootVolume); _visitables.get("bootVolume").add(this.bootVolume);} else { this.bootVolume = null; _visitables.get("bootVolume").remove(this.bootVolume); } return (A) this;
  }
  public boolean hasBootVolume() {
    return this.bootVolume != null;
  }
  public A withNewBootVolume(String encryptionKey) {
    return (A)withBootVolume(new BootVolume(encryptionKey));
  }
  public BootVolumeNested<A> withNewBootVolume() {
    return new BootVolumeNested(null);
  }
  public BootVolumeNested<A> withNewBootVolumeLike(BootVolume item) {
    return new BootVolumeNested(item);
  }
  public BootVolumeNested<A> editBootVolume() {
    return withNewBootVolumeLike(java.util.Optional.ofNullable(buildBootVolume()).orElse(null));
  }
  public BootVolumeNested<A> editOrNewBootVolume() {
    return withNewBootVolumeLike(java.util.Optional.ofNullable(buildBootVolume()).orElse(new BootVolumeBuilder().build()));
  }
  public BootVolumeNested<A> editOrNewBootVolumeLike(BootVolume item) {
    return withNewBootVolumeLike(java.util.Optional.ofNullable(buildBootVolume()).orElse(item));
  }
  public A addToDedicatedHosts(int index,DedicatedHost item) {
    if (this.dedicatedHosts == null) {this.dedicatedHosts = new ArrayList<DedicatedHostBuilder>();}
    DedicatedHostBuilder builder = new DedicatedHostBuilder(item);
    if (index < 0 || index >= dedicatedHosts.size()) { _visitables.get("dedicatedHosts").add(builder); dedicatedHosts.add(builder); } else { _visitables.get("dedicatedHosts").add(index, builder); dedicatedHosts.add(index, builder);}
    return (A)this;
  }
  public A setToDedicatedHosts(int index,DedicatedHost item) {
    if (this.dedicatedHosts == null) {this.dedicatedHosts = new ArrayList<DedicatedHostBuilder>();}
    DedicatedHostBuilder builder = new DedicatedHostBuilder(item);
    if (index < 0 || index >= dedicatedHosts.size()) { _visitables.get("dedicatedHosts").add(builder); dedicatedHosts.add(builder); } else { _visitables.get("dedicatedHosts").set(index, builder); dedicatedHosts.set(index, builder);}
    return (A)this;
  }
  public A addToDedicatedHosts(io.fabric8.openshift.api.model.installer.ibmcloud.v1.DedicatedHost... items) {
    if (this.dedicatedHosts == null) {this.dedicatedHosts = new ArrayList<DedicatedHostBuilder>();}
    for (DedicatedHost item : items) {DedicatedHostBuilder builder = new DedicatedHostBuilder(item);_visitables.get("dedicatedHosts").add(builder);this.dedicatedHosts.add(builder);} return (A)this;
  }
  public A addAllToDedicatedHosts(Collection<DedicatedHost> items) {
    if (this.dedicatedHosts == null) {this.dedicatedHosts = new ArrayList<DedicatedHostBuilder>();}
    for (DedicatedHost item : items) {DedicatedHostBuilder builder = new DedicatedHostBuilder(item);_visitables.get("dedicatedHosts").add(builder);this.dedicatedHosts.add(builder);} return (A)this;
  }
  public A removeFromDedicatedHosts(io.fabric8.openshift.api.model.installer.ibmcloud.v1.DedicatedHost... items) {
    if (this.dedicatedHosts == null) return (A)this;
    for (DedicatedHost item : items) {DedicatedHostBuilder builder = new DedicatedHostBuilder(item);_visitables.get("dedicatedHosts").remove(builder); this.dedicatedHosts.remove(builder);} return (A)this;
  }
  public A removeAllFromDedicatedHosts(Collection<DedicatedHost> items) {
    if (this.dedicatedHosts == null) return (A)this;
    for (DedicatedHost item : items) {DedicatedHostBuilder builder = new DedicatedHostBuilder(item);_visitables.get("dedicatedHosts").remove(builder); this.dedicatedHosts.remove(builder);} return (A)this;
  }
  public A removeMatchingFromDedicatedHosts(Predicate<DedicatedHostBuilder> predicate) {
    if (dedicatedHosts == null) return (A) this;
    final Iterator<DedicatedHostBuilder> each = dedicatedHosts.iterator();
    final List visitables = _visitables.get("dedicatedHosts");
    while (each.hasNext()) {
      DedicatedHostBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<DedicatedHost> buildDedicatedHosts() {
    return dedicatedHosts != null ? build(dedicatedHosts) : null;
  }
  public DedicatedHost buildDedicatedHost(int index) {
    return this.dedicatedHosts.get(index).build();
  }
  public DedicatedHost buildFirstDedicatedHost() {
    return this.dedicatedHosts.get(0).build();
  }
  public DedicatedHost buildLastDedicatedHost() {
    return this.dedicatedHosts.get(dedicatedHosts.size() - 1).build();
  }
  public DedicatedHost buildMatchingDedicatedHost(Predicate<DedicatedHostBuilder> predicate) {
    for (DedicatedHostBuilder item: dedicatedHosts) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingDedicatedHost(Predicate<DedicatedHostBuilder> predicate) {
    for (DedicatedHostBuilder item: dedicatedHosts) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withDedicatedHosts(List<DedicatedHost> dedicatedHosts) {
    if (this.dedicatedHosts != null) { _visitables.get("dedicatedHosts").clear();}
    if (dedicatedHosts != null) {this.dedicatedHosts = new ArrayList(); for (DedicatedHost item : dedicatedHosts){this.addToDedicatedHosts(item);}} else { this.dedicatedHosts = null;} return (A) this;
  }
  public A withDedicatedHosts(io.fabric8.openshift.api.model.installer.ibmcloud.v1.DedicatedHost... dedicatedHosts) {
    if (this.dedicatedHosts != null) {this.dedicatedHosts.clear(); _visitables.remove("dedicatedHosts"); }
    if (dedicatedHosts != null) {for (DedicatedHost item :dedicatedHosts){ this.addToDedicatedHosts(item);}} return (A) this;
  }
  public boolean hasDedicatedHosts() {
    return dedicatedHosts != null && !dedicatedHosts.isEmpty();
  }
  public A addNewDedicatedHost(String name,String profile) {
    return (A)addToDedicatedHosts(new DedicatedHost(name, profile));
  }
  public DedicatedHostsNested<A> addNewDedicatedHost() {
    return new DedicatedHostsNested(-1, null);
  }
  public DedicatedHostsNested<A> addNewDedicatedHostLike(DedicatedHost item) {
    return new DedicatedHostsNested(-1, item);
  }
  public DedicatedHostsNested<A> setNewDedicatedHostLike(int index,DedicatedHost item) {
    return new DedicatedHostsNested(index, item);
  }
  public DedicatedHostsNested<A> editDedicatedHost(int index) {
    if (dedicatedHosts.size() <= index) throw new RuntimeException("Can't edit dedicatedHosts. Index exceeds size.");
    return setNewDedicatedHostLike(index, buildDedicatedHost(index));
  }
  public DedicatedHostsNested<A> editFirstDedicatedHost() {
    if (dedicatedHosts.size() == 0) throw new RuntimeException("Can't edit first dedicatedHosts. The list is empty.");
    return setNewDedicatedHostLike(0, buildDedicatedHost(0));
  }
  public DedicatedHostsNested<A> editLastDedicatedHost() {
    int index = dedicatedHosts.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last dedicatedHosts. The list is empty.");
    return setNewDedicatedHostLike(index, buildDedicatedHost(index));
  }
  public DedicatedHostsNested<A> editMatchingDedicatedHost(Predicate<DedicatedHostBuilder> predicate) {
    int index = -1;
    for (int i=0;i<dedicatedHosts.size();i++) { 
    if (predicate.test(dedicatedHosts.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching dedicatedHosts. No match found.");
    return setNewDedicatedHostLike(index, buildDedicatedHost(index));
  }
  public String getType() {
    return this.type;
  }
  public A withType(String type) {
    this.type=type; return (A) this;
  }
  public boolean hasType() {
    return this.type != null;
  }
  public A addToZones(int index,String item) {
    if (this.zones == null) {this.zones = new ArrayList<String>();}
    this.zones.add(index, item);
    return (A)this;
  }
  public A setToZones(int index,String item) {
    if (this.zones == null) {this.zones = new ArrayList<String>();}
    this.zones.set(index, item); return (A)this;
  }
  public A addToZones(java.lang.String... items) {
    if (this.zones == null) {this.zones = new ArrayList<String>();}
    for (String item : items) {this.zones.add(item);} return (A)this;
  }
  public A addAllToZones(Collection<String> items) {
    if (this.zones == null) {this.zones = new ArrayList<String>();}
    for (String item : items) {this.zones.add(item);} return (A)this;
  }
  public A removeFromZones(java.lang.String... items) {
    if (this.zones == null) return (A)this;
    for (String item : items) { this.zones.remove(item);} return (A)this;
  }
  public A removeAllFromZones(Collection<String> items) {
    if (this.zones == null) return (A)this;
    for (String item : items) { this.zones.remove(item);} return (A)this;
  }
  public List<String> getZones() {
    return this.zones;
  }
  public String getZone(int index) {
    return this.zones.get(index);
  }
  public String getFirstZone() {
    return this.zones.get(0);
  }
  public String getLastZone() {
    return this.zones.get(zones.size() - 1);
  }
  public String getMatchingZone(Predicate<String> predicate) {
    for (String item: zones) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingZone(Predicate<String> predicate) {
    for (String item: zones) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withZones(List<String> zones) {
    if (zones != null) {this.zones = new ArrayList(); for (String item : zones){this.addToZones(item);}} else { this.zones = null;} return (A) this;
  }
  public A withZones(java.lang.String... zones) {
    if (this.zones != null) {this.zones.clear(); _visitables.remove("zones"); }
    if (zones != null) {for (String item :zones){ this.addToZones(item);}} return (A) this;
  }
  public boolean hasZones() {
    return zones != null && !zones.isEmpty();
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    MachinePoolFluent that = (MachinePoolFluent) o;
    if (!java.util.Objects.equals(bootVolume, that.bootVolume)) return false;

    if (!java.util.Objects.equals(dedicatedHosts, that.dedicatedHosts)) return false;

    if (!java.util.Objects.equals(type, that.type)) return false;

    if (!java.util.Objects.equals(zones, that.zones)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(bootVolume,  dedicatedHosts,  type,  zones,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (bootVolume != null) { sb.append("bootVolume:"); sb.append(bootVolume + ","); }
    if (dedicatedHosts != null && !dedicatedHosts.isEmpty()) { sb.append("dedicatedHosts:"); sb.append(dedicatedHosts + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (zones != null && !zones.isEmpty()) { sb.append("zones:"); sb.append(zones + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class BootVolumeNested<N> extends BootVolumeFluent<BootVolumeNested<N>> implements Nested<N>{
    BootVolumeNested(BootVolume item) {
      this.builder = new BootVolumeBuilder(this, item);
    }
    BootVolumeBuilder builder;
    public N and() {
      return (N) MachinePoolFluent.this.withBootVolume(builder.build());
    }
    public N endBootVolume() {
      return and();
    }
    
  }
  public class DedicatedHostsNested<N> extends DedicatedHostFluent<DedicatedHostsNested<N>> implements Nested<N>{
    DedicatedHostsNested(int index,DedicatedHost item) {
      this.index = index;
      this.builder = new DedicatedHostBuilder(this, item);
    }
    DedicatedHostBuilder builder;
    int index;
    public N and() {
      return (N) MachinePoolFluent.this.setToDedicatedHosts(index,builder.build());
    }
    public N endDedicatedHost() {
      return and();
    }
    
  }
  
}