package io.fabric8.openshift.api.model.installer.ibmcloud.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PlatformBuilder extends PlatformFluent<PlatformBuilder> implements VisitableBuilder<Platform,PlatformBuilder>{
  public PlatformBuilder() {
    this(false);
  }
  public PlatformBuilder(Boolean validationEnabled) {
    this(new Platform(), validationEnabled);
  }
  public PlatformBuilder(PlatformFluent<?> fluent) {
    this(fluent, false);
  }
  public PlatformBuilder(PlatformFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Platform(), validationEnabled);
  }
  public PlatformBuilder(PlatformFluent<?> fluent,Platform instance) {
    this(fluent, instance, false);
  }
  public PlatformBuilder(PlatformFluent<?> fluent,Platform instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Platform());

    if (instance != null) {
      fluent.withComputeSubnets(instance.getComputeSubnets());
      fluent.withControlPlaneSubnets(instance.getControlPlaneSubnets());
      fluent.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
      fluent.withNetworkResourceGroupName(instance.getNetworkResourceGroupName());
      fluent.withRegion(instance.getRegion());
      fluent.withResourceGroupName(instance.getResourceGroupName());
      fluent.withVpcName(instance.getVpcName());
      fluent.withComputeSubnets(instance.getComputeSubnets());
      fluent.withControlPlaneSubnets(instance.getControlPlaneSubnets());
      fluent.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
      fluent.withNetworkResourceGroupName(instance.getNetworkResourceGroupName());
      fluent.withRegion(instance.getRegion());
      fluent.withResourceGroupName(instance.getResourceGroupName());
      fluent.withVpcName(instance.getVpcName());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PlatformBuilder(Platform instance) {
    this(instance,false);
  }
  public PlatformBuilder(Platform instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Platform());

    if (instance != null) {
      this.withComputeSubnets(instance.getComputeSubnets());
      this.withControlPlaneSubnets(instance.getControlPlaneSubnets());
      this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
      this.withNetworkResourceGroupName(instance.getNetworkResourceGroupName());
      this.withRegion(instance.getRegion());
      this.withResourceGroupName(instance.getResourceGroupName());
      this.withVpcName(instance.getVpcName());
      this.withComputeSubnets(instance.getComputeSubnets());
      this.withControlPlaneSubnets(instance.getControlPlaneSubnets());
      this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
      this.withNetworkResourceGroupName(instance.getNetworkResourceGroupName());
      this.withRegion(instance.getRegion());
      this.withResourceGroupName(instance.getResourceGroupName());
      this.withVpcName(instance.getVpcName());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PlatformFluent<?> fluent;
  Boolean validationEnabled;
  public Platform build() {
    Platform buildable = new Platform(fluent.getComputeSubnets(),fluent.getControlPlaneSubnets(),fluent.buildDefaultMachinePlatform(),fluent.getNetworkResourceGroupName(),fluent.getRegion(),fluent.getResourceGroupName(),fluent.getVpcName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}