package io.fabric8.openshift.api.model.installer.ibmcloud.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PlatformFluent<A extends PlatformFluent<A>> extends BaseFluent<A>{
  public PlatformFluent() {
  }
  public PlatformFluent(Platform instance) {
    instance = (instance != null ? instance : new Platform());

    if (instance != null) {
      this.withComputeSubnets(instance.getComputeSubnets());
      this.withControlPlaneSubnets(instance.getControlPlaneSubnets());
      this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
      this.withNetworkResourceGroupName(instance.getNetworkResourceGroupName());
      this.withRegion(instance.getRegion());
      this.withResourceGroupName(instance.getResourceGroupName());
      this.withVpcName(instance.getVpcName());
      this.withComputeSubnets(instance.getComputeSubnets());
      this.withControlPlaneSubnets(instance.getControlPlaneSubnets());
      this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
      this.withNetworkResourceGroupName(instance.getNetworkResourceGroupName());
      this.withRegion(instance.getRegion());
      this.withResourceGroupName(instance.getResourceGroupName());
      this.withVpcName(instance.getVpcName());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private List<String> computeSubnets = new ArrayList<String>();
  private List<String> controlPlaneSubnets = new ArrayList<String>();
  private MachinePoolBuilder defaultMachinePlatform;
  private String networkResourceGroupName;
  private String region;
  private String resourceGroupName;
  private String vpcName;
  private Map<String,Object> additionalProperties;
  public A addToComputeSubnets(int index,String item) {
    if (this.computeSubnets == null) {this.computeSubnets = new ArrayList<String>();}
    this.computeSubnets.add(index, item);
    return (A)this;
  }
  public A setToComputeSubnets(int index,String item) {
    if (this.computeSubnets == null) {this.computeSubnets = new ArrayList<String>();}
    this.computeSubnets.set(index, item); return (A)this;
  }
  public A addToComputeSubnets(java.lang.String... items) {
    if (this.computeSubnets == null) {this.computeSubnets = new ArrayList<String>();}
    for (String item : items) {this.computeSubnets.add(item);} return (A)this;
  }
  public A addAllToComputeSubnets(Collection<String> items) {
    if (this.computeSubnets == null) {this.computeSubnets = new ArrayList<String>();}
    for (String item : items) {this.computeSubnets.add(item);} return (A)this;
  }
  public A removeFromComputeSubnets(java.lang.String... items) {
    if (this.computeSubnets == null) return (A)this;
    for (String item : items) { this.computeSubnets.remove(item);} return (A)this;
  }
  public A removeAllFromComputeSubnets(Collection<String> items) {
    if (this.computeSubnets == null) return (A)this;
    for (String item : items) { this.computeSubnets.remove(item);} return (A)this;
  }
  public List<String> getComputeSubnets() {
    return this.computeSubnets;
  }
  public String getComputeSubnet(int index) {
    return this.computeSubnets.get(index);
  }
  public String getFirstComputeSubnet() {
    return this.computeSubnets.get(0);
  }
  public String getLastComputeSubnet() {
    return this.computeSubnets.get(computeSubnets.size() - 1);
  }
  public String getMatchingComputeSubnet(Predicate<String> predicate) {
    for (String item: computeSubnets) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingComputeSubnet(Predicate<String> predicate) {
    for (String item: computeSubnets) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withComputeSubnets(List<String> computeSubnets) {
    if (computeSubnets != null) {this.computeSubnets = new ArrayList(); for (String item : computeSubnets){this.addToComputeSubnets(item);}} else { this.computeSubnets = null;} return (A) this;
  }
  public A withComputeSubnets(java.lang.String... computeSubnets) {
    if (this.computeSubnets != null) {this.computeSubnets.clear(); _visitables.remove("computeSubnets"); }
    if (computeSubnets != null) {for (String item :computeSubnets){ this.addToComputeSubnets(item);}} return (A) this;
  }
  public boolean hasComputeSubnets() {
    return computeSubnets != null && !computeSubnets.isEmpty();
  }
  public A addToControlPlaneSubnets(int index,String item) {
    if (this.controlPlaneSubnets == null) {this.controlPlaneSubnets = new ArrayList<String>();}
    this.controlPlaneSubnets.add(index, item);
    return (A)this;
  }
  public A setToControlPlaneSubnets(int index,String item) {
    if (this.controlPlaneSubnets == null) {this.controlPlaneSubnets = new ArrayList<String>();}
    this.controlPlaneSubnets.set(index, item); return (A)this;
  }
  public A addToControlPlaneSubnets(java.lang.String... items) {
    if (this.controlPlaneSubnets == null) {this.controlPlaneSubnets = new ArrayList<String>();}
    for (String item : items) {this.controlPlaneSubnets.add(item);} return (A)this;
  }
  public A addAllToControlPlaneSubnets(Collection<String> items) {
    if (this.controlPlaneSubnets == null) {this.controlPlaneSubnets = new ArrayList<String>();}
    for (String item : items) {this.controlPlaneSubnets.add(item);} return (A)this;
  }
  public A removeFromControlPlaneSubnets(java.lang.String... items) {
    if (this.controlPlaneSubnets == null) return (A)this;
    for (String item : items) { this.controlPlaneSubnets.remove(item);} return (A)this;
  }
  public A removeAllFromControlPlaneSubnets(Collection<String> items) {
    if (this.controlPlaneSubnets == null) return (A)this;
    for (String item : items) { this.controlPlaneSubnets.remove(item);} return (A)this;
  }
  public List<String> getControlPlaneSubnets() {
    return this.controlPlaneSubnets;
  }
  public String getControlPlaneSubnet(int index) {
    return this.controlPlaneSubnets.get(index);
  }
  public String getFirstControlPlaneSubnet() {
    return this.controlPlaneSubnets.get(0);
  }
  public String getLastControlPlaneSubnet() {
    return this.controlPlaneSubnets.get(controlPlaneSubnets.size() - 1);
  }
  public String getMatchingControlPlaneSubnet(Predicate<String> predicate) {
    for (String item: controlPlaneSubnets) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingControlPlaneSubnet(Predicate<String> predicate) {
    for (String item: controlPlaneSubnets) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withControlPlaneSubnets(List<String> controlPlaneSubnets) {
    if (controlPlaneSubnets != null) {this.controlPlaneSubnets = new ArrayList(); for (String item : controlPlaneSubnets){this.addToControlPlaneSubnets(item);}} else { this.controlPlaneSubnets = null;} return (A) this;
  }
  public A withControlPlaneSubnets(java.lang.String... controlPlaneSubnets) {
    if (this.controlPlaneSubnets != null) {this.controlPlaneSubnets.clear(); _visitables.remove("controlPlaneSubnets"); }
    if (controlPlaneSubnets != null) {for (String item :controlPlaneSubnets){ this.addToControlPlaneSubnets(item);}} return (A) this;
  }
  public boolean hasControlPlaneSubnets() {
    return controlPlaneSubnets != null && !controlPlaneSubnets.isEmpty();
  }
  public MachinePool buildDefaultMachinePlatform() {
    return this.defaultMachinePlatform!=null ?this.defaultMachinePlatform.build():null;
  }
  public A withDefaultMachinePlatform(MachinePool defaultMachinePlatform) {
    _visitables.get("defaultMachinePlatform").remove(this.defaultMachinePlatform);
    if (defaultMachinePlatform!=null){ this.defaultMachinePlatform= new MachinePoolBuilder(defaultMachinePlatform); _visitables.get("defaultMachinePlatform").add(this.defaultMachinePlatform);} else { this.defaultMachinePlatform = null; _visitables.get("defaultMachinePlatform").remove(this.defaultMachinePlatform); } return (A) this;
  }
  public boolean hasDefaultMachinePlatform() {
    return this.defaultMachinePlatform != null;
  }
  public DefaultMachinePlatformNested<A> withNewDefaultMachinePlatform() {
    return new DefaultMachinePlatformNested(null);
  }
  public DefaultMachinePlatformNested<A> withNewDefaultMachinePlatformLike(MachinePool item) {
    return new DefaultMachinePlatformNested(item);
  }
  public DefaultMachinePlatformNested<A> editDefaultMachinePlatform() {
    return withNewDefaultMachinePlatformLike(java.util.Optional.ofNullable(buildDefaultMachinePlatform()).orElse(null));
  }
  public DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatform() {
    return withNewDefaultMachinePlatformLike(java.util.Optional.ofNullable(buildDefaultMachinePlatform()).orElse(new MachinePoolBuilder().build()));
  }
  public DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatformLike(MachinePool item) {
    return withNewDefaultMachinePlatformLike(java.util.Optional.ofNullable(buildDefaultMachinePlatform()).orElse(item));
  }
  public String getNetworkResourceGroupName() {
    return this.networkResourceGroupName;
  }
  public A withNetworkResourceGroupName(String networkResourceGroupName) {
    this.networkResourceGroupName=networkResourceGroupName; return (A) this;
  }
  public boolean hasNetworkResourceGroupName() {
    return this.networkResourceGroupName != null;
  }
  public String getRegion() {
    return this.region;
  }
  public A withRegion(String region) {
    this.region=region; return (A) this;
  }
  public boolean hasRegion() {
    return this.region != null;
  }
  public String getResourceGroupName() {
    return this.resourceGroupName;
  }
  public A withResourceGroupName(String resourceGroupName) {
    this.resourceGroupName=resourceGroupName; return (A) this;
  }
  public boolean hasResourceGroupName() {
    return this.resourceGroupName != null;
  }
  public String getVpcName() {
    return this.vpcName;
  }
  public A withVpcName(String vpcName) {
    this.vpcName=vpcName; return (A) this;
  }
  public boolean hasVpcName() {
    return this.vpcName != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PlatformFluent that = (PlatformFluent) o;
    if (!java.util.Objects.equals(computeSubnets, that.computeSubnets)) return false;

    if (!java.util.Objects.equals(controlPlaneSubnets, that.controlPlaneSubnets)) return false;

    if (!java.util.Objects.equals(defaultMachinePlatform, that.defaultMachinePlatform)) return false;

    if (!java.util.Objects.equals(networkResourceGroupName, that.networkResourceGroupName)) return false;

    if (!java.util.Objects.equals(region, that.region)) return false;

    if (!java.util.Objects.equals(resourceGroupName, that.resourceGroupName)) return false;

    if (!java.util.Objects.equals(vpcName, that.vpcName)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(computeSubnets,  controlPlaneSubnets,  defaultMachinePlatform,  networkResourceGroupName,  region,  resourceGroupName,  vpcName,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (computeSubnets != null && !computeSubnets.isEmpty()) { sb.append("computeSubnets:"); sb.append(computeSubnets + ","); }
    if (controlPlaneSubnets != null && !controlPlaneSubnets.isEmpty()) { sb.append("controlPlaneSubnets:"); sb.append(controlPlaneSubnets + ","); }
    if (defaultMachinePlatform != null) { sb.append("defaultMachinePlatform:"); sb.append(defaultMachinePlatform + ","); }
    if (networkResourceGroupName != null) { sb.append("networkResourceGroupName:"); sb.append(networkResourceGroupName + ","); }
    if (region != null) { sb.append("region:"); sb.append(region + ","); }
    if (resourceGroupName != null) { sb.append("resourceGroupName:"); sb.append(resourceGroupName + ","); }
    if (vpcName != null) { sb.append("vpcName:"); sb.append(vpcName + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class DefaultMachinePlatformNested<N> extends MachinePoolFluent<DefaultMachinePlatformNested<N>> implements Nested<N>{
    DefaultMachinePlatformNested(MachinePool item) {
      this.builder = new MachinePoolBuilder(this, item);
    }
    MachinePoolBuilder builder;
    public N and() {
      return (N) PlatformFluent.this.withDefaultMachinePlatform(builder.build());
    }
    public N endDefaultMachinePlatform() {
      return and();
    }
    
  }
  
}