package io.fabric8.openshift.api.model.installer.nutanix.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OSDiskBuilder extends OSDiskFluent<OSDiskBuilder> implements VisitableBuilder<OSDisk,OSDiskBuilder>{
  public OSDiskBuilder() {
    this(false);
  }
  public OSDiskBuilder(Boolean validationEnabled) {
    this(new OSDisk(), validationEnabled);
  }
  public OSDiskBuilder(OSDiskFluent<?> fluent) {
    this(fluent, false);
  }
  public OSDiskBuilder(OSDiskFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OSDisk(), validationEnabled);
  }
  public OSDiskBuilder(OSDiskFluent<?> fluent,OSDisk instance) {
    this(fluent, instance, false);
  }
  public OSDiskBuilder(OSDiskFluent<?> fluent,OSDisk instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new OSDisk());

    if (instance != null) {
      fluent.withDiskSizeGiB(instance.getDiskSizeGiB());
      fluent.withDiskSizeGiB(instance.getDiskSizeGiB());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public OSDiskBuilder(OSDisk instance) {
    this(instance,false);
  }
  public OSDiskBuilder(OSDisk instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new OSDisk());

    if (instance != null) {
      this.withDiskSizeGiB(instance.getDiskSizeGiB());
      this.withDiskSizeGiB(instance.getDiskSizeGiB());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  OSDiskFluent<?> fluent;
  Boolean validationEnabled;
  public OSDisk build() {
    OSDisk buildable = new OSDisk(fluent.getDiskSizeGiB());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}