package io.fabric8.openshift.api.model.installer.openstack.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class FailureDomainBuilder extends FailureDomainFluent<FailureDomainBuilder> implements VisitableBuilder<FailureDomain,FailureDomainBuilder>{
  public FailureDomainBuilder() {
    this(false);
  }
  public FailureDomainBuilder(Boolean validationEnabled) {
    this(new FailureDomain(), validationEnabled);
  }
  public FailureDomainBuilder(FailureDomainFluent<?> fluent) {
    this(fluent, false);
  }
  public FailureDomainBuilder(FailureDomainFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new FailureDomain(), validationEnabled);
  }
  public FailureDomainBuilder(FailureDomainFluent<?> fluent,FailureDomain instance) {
    this(fluent, instance, false);
  }
  public FailureDomainBuilder(FailureDomainFluent<?> fluent,FailureDomain instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new FailureDomain());

    if (instance != null) {
      fluent.withComputeAvailabilityZone(instance.getComputeAvailabilityZone());
      fluent.withPortTargets(instance.getPortTargets());
      fluent.withStorageAvailabilityZone(instance.getStorageAvailabilityZone());
      fluent.withComputeAvailabilityZone(instance.getComputeAvailabilityZone());
      fluent.withPortTargets(instance.getPortTargets());
      fluent.withStorageAvailabilityZone(instance.getStorageAvailabilityZone());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public FailureDomainBuilder(FailureDomain instance) {
    this(instance,false);
  }
  public FailureDomainBuilder(FailureDomain instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new FailureDomain());

    if (instance != null) {
      this.withComputeAvailabilityZone(instance.getComputeAvailabilityZone());
      this.withPortTargets(instance.getPortTargets());
      this.withStorageAvailabilityZone(instance.getStorageAvailabilityZone());
      this.withComputeAvailabilityZone(instance.getComputeAvailabilityZone());
      this.withPortTargets(instance.getPortTargets());
      this.withStorageAvailabilityZone(instance.getStorageAvailabilityZone());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  FailureDomainFluent<?> fluent;
  Boolean validationEnabled;
  public FailureDomain build() {
    FailureDomain buildable = new FailureDomain(fluent.getComputeAvailabilityZone(),fluent.buildPortTargets(),fluent.getStorageAvailabilityZone());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}