package io.fabric8.openshift.api.model.installer.openstack.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class FailureDomainFluent<A extends FailureDomainFluent<A>> extends BaseFluent<A>{
  public FailureDomainFluent() {
  }
  public FailureDomainFluent(FailureDomain instance) {
    instance = (instance != null ? instance : new FailureDomain());

    if (instance != null) {
      this.withComputeAvailabilityZone(instance.getComputeAvailabilityZone());
      this.withPortTargets(instance.getPortTargets());
      this.withStorageAvailabilityZone(instance.getStorageAvailabilityZone());
      this.withComputeAvailabilityZone(instance.getComputeAvailabilityZone());
      this.withPortTargets(instance.getPortTargets());
      this.withStorageAvailabilityZone(instance.getStorageAvailabilityZone());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String computeAvailabilityZone;
  private ArrayList<NamedPortTargetBuilder> portTargets = new ArrayList<NamedPortTargetBuilder>();
  private String storageAvailabilityZone;
  private Map<String,Object> additionalProperties;
  public String getComputeAvailabilityZone() {
    return this.computeAvailabilityZone;
  }
  public A withComputeAvailabilityZone(String computeAvailabilityZone) {
    this.computeAvailabilityZone=computeAvailabilityZone; return (A) this;
  }
  public boolean hasComputeAvailabilityZone() {
    return this.computeAvailabilityZone != null;
  }
  public A addToPortTargets(int index,NamedPortTarget item) {
    if (this.portTargets == null) {this.portTargets = new ArrayList<NamedPortTargetBuilder>();}
    NamedPortTargetBuilder builder = new NamedPortTargetBuilder(item);
    if (index < 0 || index >= portTargets.size()) { _visitables.get("portTargets").add(builder); portTargets.add(builder); } else { _visitables.get("portTargets").add(index, builder); portTargets.add(index, builder);}
    return (A)this;
  }
  public A setToPortTargets(int index,NamedPortTarget item) {
    if (this.portTargets == null) {this.portTargets = new ArrayList<NamedPortTargetBuilder>();}
    NamedPortTargetBuilder builder = new NamedPortTargetBuilder(item);
    if (index < 0 || index >= portTargets.size()) { _visitables.get("portTargets").add(builder); portTargets.add(builder); } else { _visitables.get("portTargets").set(index, builder); portTargets.set(index, builder);}
    return (A)this;
  }
  public A addToPortTargets(io.fabric8.openshift.api.model.installer.openstack.v1.NamedPortTarget... items) {
    if (this.portTargets == null) {this.portTargets = new ArrayList<NamedPortTargetBuilder>();}
    for (NamedPortTarget item : items) {NamedPortTargetBuilder builder = new NamedPortTargetBuilder(item);_visitables.get("portTargets").add(builder);this.portTargets.add(builder);} return (A)this;
  }
  public A addAllToPortTargets(Collection<NamedPortTarget> items) {
    if (this.portTargets == null) {this.portTargets = new ArrayList<NamedPortTargetBuilder>();}
    for (NamedPortTarget item : items) {NamedPortTargetBuilder builder = new NamedPortTargetBuilder(item);_visitables.get("portTargets").add(builder);this.portTargets.add(builder);} return (A)this;
  }
  public A removeFromPortTargets(io.fabric8.openshift.api.model.installer.openstack.v1.NamedPortTarget... items) {
    if (this.portTargets == null) return (A)this;
    for (NamedPortTarget item : items) {NamedPortTargetBuilder builder = new NamedPortTargetBuilder(item);_visitables.get("portTargets").remove(builder); this.portTargets.remove(builder);} return (A)this;
  }
  public A removeAllFromPortTargets(Collection<NamedPortTarget> items) {
    if (this.portTargets == null) return (A)this;
    for (NamedPortTarget item : items) {NamedPortTargetBuilder builder = new NamedPortTargetBuilder(item);_visitables.get("portTargets").remove(builder); this.portTargets.remove(builder);} return (A)this;
  }
  public A removeMatchingFromPortTargets(Predicate<NamedPortTargetBuilder> predicate) {
    if (portTargets == null) return (A) this;
    final Iterator<NamedPortTargetBuilder> each = portTargets.iterator();
    final List visitables = _visitables.get("portTargets");
    while (each.hasNext()) {
      NamedPortTargetBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<NamedPortTarget> buildPortTargets() {
    return portTargets != null ? build(portTargets) : null;
  }
  public NamedPortTarget buildPortTarget(int index) {
    return this.portTargets.get(index).build();
  }
  public NamedPortTarget buildFirstPortTarget() {
    return this.portTargets.get(0).build();
  }
  public NamedPortTarget buildLastPortTarget() {
    return this.portTargets.get(portTargets.size() - 1).build();
  }
  public NamedPortTarget buildMatchingPortTarget(Predicate<NamedPortTargetBuilder> predicate) {
    for (NamedPortTargetBuilder item: portTargets) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingPortTarget(Predicate<NamedPortTargetBuilder> predicate) {
    for (NamedPortTargetBuilder item: portTargets) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withPortTargets(List<NamedPortTarget> portTargets) {
    if (this.portTargets != null) { _visitables.get("portTargets").clear();}
    if (portTargets != null) {this.portTargets = new ArrayList(); for (NamedPortTarget item : portTargets){this.addToPortTargets(item);}} else { this.portTargets = null;} return (A) this;
  }
  public A withPortTargets(io.fabric8.openshift.api.model.installer.openstack.v1.NamedPortTarget... portTargets) {
    if (this.portTargets != null) {this.portTargets.clear(); _visitables.remove("portTargets"); }
    if (portTargets != null) {for (NamedPortTarget item :portTargets){ this.addToPortTargets(item);}} return (A) this;
  }
  public boolean hasPortTargets() {
    return portTargets != null && !portTargets.isEmpty();
  }
  public PortTargetsNested<A> addNewPortTarget() {
    return new PortTargetsNested(-1, null);
  }
  public PortTargetsNested<A> addNewPortTargetLike(NamedPortTarget item) {
    return new PortTargetsNested(-1, item);
  }
  public PortTargetsNested<A> setNewPortTargetLike(int index,NamedPortTarget item) {
    return new PortTargetsNested(index, item);
  }
  public PortTargetsNested<A> editPortTarget(int index) {
    if (portTargets.size() <= index) throw new RuntimeException("Can't edit portTargets. Index exceeds size.");
    return setNewPortTargetLike(index, buildPortTarget(index));
  }
  public PortTargetsNested<A> editFirstPortTarget() {
    if (portTargets.size() == 0) throw new RuntimeException("Can't edit first portTargets. The list is empty.");
    return setNewPortTargetLike(0, buildPortTarget(0));
  }
  public PortTargetsNested<A> editLastPortTarget() {
    int index = portTargets.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last portTargets. The list is empty.");
    return setNewPortTargetLike(index, buildPortTarget(index));
  }
  public PortTargetsNested<A> editMatchingPortTarget(Predicate<NamedPortTargetBuilder> predicate) {
    int index = -1;
    for (int i=0;i<portTargets.size();i++) { 
    if (predicate.test(portTargets.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching portTargets. No match found.");
    return setNewPortTargetLike(index, buildPortTarget(index));
  }
  public String getStorageAvailabilityZone() {
    return this.storageAvailabilityZone;
  }
  public A withStorageAvailabilityZone(String storageAvailabilityZone) {
    this.storageAvailabilityZone=storageAvailabilityZone; return (A) this;
  }
  public boolean hasStorageAvailabilityZone() {
    return this.storageAvailabilityZone != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    FailureDomainFluent that = (FailureDomainFluent) o;
    if (!java.util.Objects.equals(computeAvailabilityZone, that.computeAvailabilityZone)) return false;

    if (!java.util.Objects.equals(portTargets, that.portTargets)) return false;

    if (!java.util.Objects.equals(storageAvailabilityZone, that.storageAvailabilityZone)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(computeAvailabilityZone,  portTargets,  storageAvailabilityZone,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (computeAvailabilityZone != null) { sb.append("computeAvailabilityZone:"); sb.append(computeAvailabilityZone + ","); }
    if (portTargets != null && !portTargets.isEmpty()) { sb.append("portTargets:"); sb.append(portTargets + ","); }
    if (storageAvailabilityZone != null) { sb.append("storageAvailabilityZone:"); sb.append(storageAvailabilityZone + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class PortTargetsNested<N> extends NamedPortTargetFluent<PortTargetsNested<N>> implements Nested<N>{
    PortTargetsNested(int index,NamedPortTarget item) {
      this.index = index;
      this.builder = new NamedPortTargetBuilder(this, item);
    }
    NamedPortTargetBuilder builder;
    int index;
    public N and() {
      return (N) FailureDomainFluent.this.setToPortTargets(index,builder.build());
    }
    public N endPortTarget() {
      return and();
    }
    
  }
  
}