package io.fabric8.openshift.api.model.installer.openstack.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class FixedIPBuilder extends FixedIPFluent<FixedIPBuilder> implements VisitableBuilder<FixedIP,FixedIPBuilder>{
  public FixedIPBuilder() {
    this(false);
  }
  public FixedIPBuilder(Boolean validationEnabled) {
    this(new FixedIP(), validationEnabled);
  }
  public FixedIPBuilder(FixedIPFluent<?> fluent) {
    this(fluent, false);
  }
  public FixedIPBuilder(FixedIPFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new FixedIP(), validationEnabled);
  }
  public FixedIPBuilder(FixedIPFluent<?> fluent,FixedIP instance) {
    this(fluent, instance, false);
  }
  public FixedIPBuilder(FixedIPFluent<?> fluent,FixedIP instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new FixedIP());

    if (instance != null) {
      fluent.withSubnet(instance.getSubnet());
      fluent.withSubnet(instance.getSubnet());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public FixedIPBuilder(FixedIP instance) {
    this(instance,false);
  }
  public FixedIPBuilder(FixedIP instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new FixedIP());

    if (instance != null) {
      this.withSubnet(instance.getSubnet());
      this.withSubnet(instance.getSubnet());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  FixedIPFluent<?> fluent;
  Boolean validationEnabled;
  public FixedIP build() {
    FixedIP buildable = new FixedIP(fluent.getSubnet());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}