package io.fabric8.openshift.api.model.installer.openstack.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.openshift.api.model.config.v1.OpenStackPlatformLoadBalancer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PlatformFluent<A extends PlatformFluent<A>> extends BaseFluent<A>{
  public PlatformFluent() {
  }
  public PlatformFluent(Platform instance) {
    instance = (instance != null ? instance : new Platform());

    if (instance != null) {
      this.withApiFloatingIP(instance.getApiFloatingIP());
      this.withApiVIP(instance.getApiVIP());
      this.withApiVIPs(instance.getApiVIPs());
      this.withCloud(instance.getCloud());
      this.withClusterOSImage(instance.getClusterOSImage());
      this.withClusterOSImageProperties(instance.getClusterOSImageProperties());
      this.withComputeFlavor(instance.getComputeFlavor());
      this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
      this.withExternalDNS(instance.getExternalDNS());
      this.withExternalNetwork(instance.getExternalNetwork());
      this.withIngressFloatingIP(instance.getIngressFloatingIP());
      this.withIngressVIP(instance.getIngressVIP());
      this.withIngressVIPs(instance.getIngressVIPs());
      this.withLbFloatingIP(instance.getLbFloatingIP());
      this.withLoadBalancer(instance.getLoadBalancer());
      this.withMachinesSubnet(instance.getMachinesSubnet());
      this.withOctaviaSupport(instance.getOctaviaSupport());
      this.withRegion(instance.getRegion());
      this.withTrunkSupport(instance.getTrunkSupport());
      this.withApiFloatingIP(instance.getApiFloatingIP());
      this.withApiVIP(instance.getApiVIP());
      this.withApiVIPs(instance.getApiVIPs());
      this.withCloud(instance.getCloud());
      this.withClusterOSImage(instance.getClusterOSImage());
      this.withClusterOSImageProperties(instance.getClusterOSImageProperties());
      this.withComputeFlavor(instance.getComputeFlavor());
      this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
      this.withExternalDNS(instance.getExternalDNS());
      this.withExternalNetwork(instance.getExternalNetwork());
      this.withIngressFloatingIP(instance.getIngressFloatingIP());
      this.withIngressVIP(instance.getIngressVIP());
      this.withIngressVIPs(instance.getIngressVIPs());
      this.withLbFloatingIP(instance.getLbFloatingIP());
      this.withLoadBalancer(instance.getLoadBalancer());
      this.withMachinesSubnet(instance.getMachinesSubnet());
      this.withOctaviaSupport(instance.getOctaviaSupport());
      this.withRegion(instance.getRegion());
      this.withTrunkSupport(instance.getTrunkSupport());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String apiFloatingIP;
  private String apiVIP;
  private List<String> apiVIPs = new ArrayList<String>();
  private String cloud;
  private String clusterOSImage;
  private Map<String,String> clusterOSImageProperties;
  private String computeFlavor;
  private MachinePoolBuilder defaultMachinePlatform;
  private List<String> externalDNS = new ArrayList<String>();
  private String externalNetwork;
  private String ingressFloatingIP;
  private String ingressVIP;
  private List<String> ingressVIPs = new ArrayList<String>();
  private String lbFloatingIP;
  private OpenStackPlatformLoadBalancer loadBalancer;
  private String machinesSubnet;
  private String octaviaSupport;
  private String region;
  private String trunkSupport;
  private Map<String,Object> additionalProperties;
  public String getApiFloatingIP() {
    return this.apiFloatingIP;
  }
  public A withApiFloatingIP(String apiFloatingIP) {
    this.apiFloatingIP=apiFloatingIP; return (A) this;
  }
  public boolean hasApiFloatingIP() {
    return this.apiFloatingIP != null;
  }
  public String getApiVIP() {
    return this.apiVIP;
  }
  public A withApiVIP(String apiVIP) {
    this.apiVIP=apiVIP; return (A) this;
  }
  public boolean hasApiVIP() {
    return this.apiVIP != null;
  }
  public A addToApiVIPs(int index,String item) {
    if (this.apiVIPs == null) {this.apiVIPs = new ArrayList<String>();}
    this.apiVIPs.add(index, item);
    return (A)this;
  }
  public A setToApiVIPs(int index,String item) {
    if (this.apiVIPs == null) {this.apiVIPs = new ArrayList<String>();}
    this.apiVIPs.set(index, item); return (A)this;
  }
  public A addToApiVIPs(java.lang.String... items) {
    if (this.apiVIPs == null) {this.apiVIPs = new ArrayList<String>();}
    for (String item : items) {this.apiVIPs.add(item);} return (A)this;
  }
  public A addAllToApiVIPs(Collection<String> items) {
    if (this.apiVIPs == null) {this.apiVIPs = new ArrayList<String>();}
    for (String item : items) {this.apiVIPs.add(item);} return (A)this;
  }
  public A removeFromApiVIPs(java.lang.String... items) {
    if (this.apiVIPs == null) return (A)this;
    for (String item : items) { this.apiVIPs.remove(item);} return (A)this;
  }
  public A removeAllFromApiVIPs(Collection<String> items) {
    if (this.apiVIPs == null) return (A)this;
    for (String item : items) { this.apiVIPs.remove(item);} return (A)this;
  }
  public List<String> getApiVIPs() {
    return this.apiVIPs;
  }
  public String getApiVIP(int index) {
    return this.apiVIPs.get(index);
  }
  public String getFirstApiVIP() {
    return this.apiVIPs.get(0);
  }
  public String getLastApiVIP() {
    return this.apiVIPs.get(apiVIPs.size() - 1);
  }
  public String getMatchingApiVIP(Predicate<String> predicate) {
    for (String item: apiVIPs) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingApiVIP(Predicate<String> predicate) {
    for (String item: apiVIPs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withApiVIPs(List<String> apiVIPs) {
    if (apiVIPs != null) {this.apiVIPs = new ArrayList(); for (String item : apiVIPs){this.addToApiVIPs(item);}} else { this.apiVIPs = null;} return (A) this;
  }
  public A withApiVIPs(java.lang.String... apiVIPs) {
    if (this.apiVIPs != null) {this.apiVIPs.clear(); _visitables.remove("apiVIPs"); }
    if (apiVIPs != null) {for (String item :apiVIPs){ this.addToApiVIPs(item);}} return (A) this;
  }
  public boolean hasApiVIPs() {
    return apiVIPs != null && !apiVIPs.isEmpty();
  }
  public String getCloud() {
    return this.cloud;
  }
  public A withCloud(String cloud) {
    this.cloud=cloud; return (A) this;
  }
  public boolean hasCloud() {
    return this.cloud != null;
  }
  public String getClusterOSImage() {
    return this.clusterOSImage;
  }
  public A withClusterOSImage(String clusterOSImage) {
    this.clusterOSImage=clusterOSImage; return (A) this;
  }
  public boolean hasClusterOSImage() {
    return this.clusterOSImage != null;
  }
  public A addToClusterOSImageProperties(String key,String value) {
    if(this.clusterOSImageProperties == null && key != null && value != null) { this.clusterOSImageProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.clusterOSImageProperties.put(key, value);} return (A)this;
  }
  public A addToClusterOSImageProperties(Map<String,String> map) {
    if(this.clusterOSImageProperties == null && map != null) { this.clusterOSImageProperties = new LinkedHashMap(); }
    if(map != null) { this.clusterOSImageProperties.putAll(map);} return (A)this;
  }
  public A removeFromClusterOSImageProperties(String key) {
    if(this.clusterOSImageProperties == null) { return (A) this; }
    if(key != null && this.clusterOSImageProperties != null) {this.clusterOSImageProperties.remove(key);} return (A)this;
  }
  public A removeFromClusterOSImageProperties(Map<String,String> map) {
    if(this.clusterOSImageProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.clusterOSImageProperties != null){this.clusterOSImageProperties.remove(key);}}} return (A)this;
  }
  public Map<String,String> getClusterOSImageProperties() {
    return this.clusterOSImageProperties;
  }
  public <K,V>A withClusterOSImageProperties(Map<String,String> clusterOSImageProperties) {
    if (clusterOSImageProperties == null) { this.clusterOSImageProperties =  null;} else {this.clusterOSImageProperties = new LinkedHashMap(clusterOSImageProperties);} return (A) this;
  }
  public boolean hasClusterOSImageProperties() {
    return this.clusterOSImageProperties != null;
  }
  public String getComputeFlavor() {
    return this.computeFlavor;
  }
  public A withComputeFlavor(String computeFlavor) {
    this.computeFlavor=computeFlavor; return (A) this;
  }
  public boolean hasComputeFlavor() {
    return this.computeFlavor != null;
  }
  public MachinePool buildDefaultMachinePlatform() {
    return this.defaultMachinePlatform!=null ?this.defaultMachinePlatform.build():null;
  }
  public A withDefaultMachinePlatform(MachinePool defaultMachinePlatform) {
    _visitables.get("defaultMachinePlatform").remove(this.defaultMachinePlatform);
    if (defaultMachinePlatform!=null){ this.defaultMachinePlatform= new MachinePoolBuilder(defaultMachinePlatform); _visitables.get("defaultMachinePlatform").add(this.defaultMachinePlatform);} else { this.defaultMachinePlatform = null; _visitables.get("defaultMachinePlatform").remove(this.defaultMachinePlatform); } return (A) this;
  }
  public boolean hasDefaultMachinePlatform() {
    return this.defaultMachinePlatform != null;
  }
  public DefaultMachinePlatformNested<A> withNewDefaultMachinePlatform() {
    return new DefaultMachinePlatformNested(null);
  }
  public DefaultMachinePlatformNested<A> withNewDefaultMachinePlatformLike(MachinePool item) {
    return new DefaultMachinePlatformNested(item);
  }
  public DefaultMachinePlatformNested<A> editDefaultMachinePlatform() {
    return withNewDefaultMachinePlatformLike(java.util.Optional.ofNullable(buildDefaultMachinePlatform()).orElse(null));
  }
  public DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatform() {
    return withNewDefaultMachinePlatformLike(java.util.Optional.ofNullable(buildDefaultMachinePlatform()).orElse(new MachinePoolBuilder().build()));
  }
  public DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatformLike(MachinePool item) {
    return withNewDefaultMachinePlatformLike(java.util.Optional.ofNullable(buildDefaultMachinePlatform()).orElse(item));
  }
  public A addToExternalDNS(int index,String item) {
    if (this.externalDNS == null) {this.externalDNS = new ArrayList<String>();}
    this.externalDNS.add(index, item);
    return (A)this;
  }
  public A setToExternalDNS(int index,String item) {
    if (this.externalDNS == null) {this.externalDNS = new ArrayList<String>();}
    this.externalDNS.set(index, item); return (A)this;
  }
  public A addToExternalDNS(java.lang.String... items) {
    if (this.externalDNS == null) {this.externalDNS = new ArrayList<String>();}
    for (String item : items) {this.externalDNS.add(item);} return (A)this;
  }
  public A addAllToExternalDNS(Collection<String> items) {
    if (this.externalDNS == null) {this.externalDNS = new ArrayList<String>();}
    for (String item : items) {this.externalDNS.add(item);} return (A)this;
  }
  public A removeFromExternalDNS(java.lang.String... items) {
    if (this.externalDNS == null) return (A)this;
    for (String item : items) { this.externalDNS.remove(item);} return (A)this;
  }
  public A removeAllFromExternalDNS(Collection<String> items) {
    if (this.externalDNS == null) return (A)this;
    for (String item : items) { this.externalDNS.remove(item);} return (A)this;
  }
  public List<String> getExternalDNS() {
    return this.externalDNS;
  }
  public String getExternalDN(int index) {
    return this.externalDNS.get(index);
  }
  public String getFirstExternalDN() {
    return this.externalDNS.get(0);
  }
  public String getLastExternalDN() {
    return this.externalDNS.get(externalDNS.size() - 1);
  }
  public String getMatchingExternalDN(Predicate<String> predicate) {
    for (String item: externalDNS) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingExternalDN(Predicate<String> predicate) {
    for (String item: externalDNS) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withExternalDNS(List<String> externalDNS) {
    if (externalDNS != null) {this.externalDNS = new ArrayList(); for (String item : externalDNS){this.addToExternalDNS(item);}} else { this.externalDNS = null;} return (A) this;
  }
  public A withExternalDNS(java.lang.String... externalDNS) {
    if (this.externalDNS != null) {this.externalDNS.clear(); _visitables.remove("externalDNS"); }
    if (externalDNS != null) {for (String item :externalDNS){ this.addToExternalDNS(item);}} return (A) this;
  }
  public boolean hasExternalDNS() {
    return externalDNS != null && !externalDNS.isEmpty();
  }
  public String getExternalNetwork() {
    return this.externalNetwork;
  }
  public A withExternalNetwork(String externalNetwork) {
    this.externalNetwork=externalNetwork; return (A) this;
  }
  public boolean hasExternalNetwork() {
    return this.externalNetwork != null;
  }
  public String getIngressFloatingIP() {
    return this.ingressFloatingIP;
  }
  public A withIngressFloatingIP(String ingressFloatingIP) {
    this.ingressFloatingIP=ingressFloatingIP; return (A) this;
  }
  public boolean hasIngressFloatingIP() {
    return this.ingressFloatingIP != null;
  }
  public String getIngressVIP() {
    return this.ingressVIP;
  }
  public A withIngressVIP(String ingressVIP) {
    this.ingressVIP=ingressVIP; return (A) this;
  }
  public boolean hasIngressVIP() {
    return this.ingressVIP != null;
  }
  public A addToIngressVIPs(int index,String item) {
    if (this.ingressVIPs == null) {this.ingressVIPs = new ArrayList<String>();}
    this.ingressVIPs.add(index, item);
    return (A)this;
  }
  public A setToIngressVIPs(int index,String item) {
    if (this.ingressVIPs == null) {this.ingressVIPs = new ArrayList<String>();}
    this.ingressVIPs.set(index, item); return (A)this;
  }
  public A addToIngressVIPs(java.lang.String... items) {
    if (this.ingressVIPs == null) {this.ingressVIPs = new ArrayList<String>();}
    for (String item : items) {this.ingressVIPs.add(item);} return (A)this;
  }
  public A addAllToIngressVIPs(Collection<String> items) {
    if (this.ingressVIPs == null) {this.ingressVIPs = new ArrayList<String>();}
    for (String item : items) {this.ingressVIPs.add(item);} return (A)this;
  }
  public A removeFromIngressVIPs(java.lang.String... items) {
    if (this.ingressVIPs == null) return (A)this;
    for (String item : items) { this.ingressVIPs.remove(item);} return (A)this;
  }
  public A removeAllFromIngressVIPs(Collection<String> items) {
    if (this.ingressVIPs == null) return (A)this;
    for (String item : items) { this.ingressVIPs.remove(item);} return (A)this;
  }
  public List<String> getIngressVIPs() {
    return this.ingressVIPs;
  }
  public String getIngressVIP(int index) {
    return this.ingressVIPs.get(index);
  }
  public String getFirstIngressVIP() {
    return this.ingressVIPs.get(0);
  }
  public String getLastIngressVIP() {
    return this.ingressVIPs.get(ingressVIPs.size() - 1);
  }
  public String getMatchingIngressVIP(Predicate<String> predicate) {
    for (String item: ingressVIPs) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingIngressVIP(Predicate<String> predicate) {
    for (String item: ingressVIPs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withIngressVIPs(List<String> ingressVIPs) {
    if (ingressVIPs != null) {this.ingressVIPs = new ArrayList(); for (String item : ingressVIPs){this.addToIngressVIPs(item);}} else { this.ingressVIPs = null;} return (A) this;
  }
  public A withIngressVIPs(java.lang.String... ingressVIPs) {
    if (this.ingressVIPs != null) {this.ingressVIPs.clear(); _visitables.remove("ingressVIPs"); }
    if (ingressVIPs != null) {for (String item :ingressVIPs){ this.addToIngressVIPs(item);}} return (A) this;
  }
  public boolean hasIngressVIPs() {
    return ingressVIPs != null && !ingressVIPs.isEmpty();
  }
  public String getLbFloatingIP() {
    return this.lbFloatingIP;
  }
  public A withLbFloatingIP(String lbFloatingIP) {
    this.lbFloatingIP=lbFloatingIP; return (A) this;
  }
  public boolean hasLbFloatingIP() {
    return this.lbFloatingIP != null;
  }
  public OpenStackPlatformLoadBalancer getLoadBalancer() {
    return this.loadBalancer;
  }
  public A withLoadBalancer(OpenStackPlatformLoadBalancer loadBalancer) {
    this.loadBalancer=loadBalancer; return (A) this;
  }
  public boolean hasLoadBalancer() {
    return this.loadBalancer != null;
  }
  public A withNewLoadBalancer(String type) {
    return (A)withLoadBalancer(new OpenStackPlatformLoadBalancer(type));
  }
  public String getMachinesSubnet() {
    return this.machinesSubnet;
  }
  public A withMachinesSubnet(String machinesSubnet) {
    this.machinesSubnet=machinesSubnet; return (A) this;
  }
  public boolean hasMachinesSubnet() {
    return this.machinesSubnet != null;
  }
  public String getOctaviaSupport() {
    return this.octaviaSupport;
  }
  public A withOctaviaSupport(String octaviaSupport) {
    this.octaviaSupport=octaviaSupport; return (A) this;
  }
  public boolean hasOctaviaSupport() {
    return this.octaviaSupport != null;
  }
  public String getRegion() {
    return this.region;
  }
  public A withRegion(String region) {
    this.region=region; return (A) this;
  }
  public boolean hasRegion() {
    return this.region != null;
  }
  public String getTrunkSupport() {
    return this.trunkSupport;
  }
  public A withTrunkSupport(String trunkSupport) {
    this.trunkSupport=trunkSupport; return (A) this;
  }
  public boolean hasTrunkSupport() {
    return this.trunkSupport != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PlatformFluent that = (PlatformFluent) o;
    if (!java.util.Objects.equals(apiFloatingIP, that.apiFloatingIP)) return false;

    if (!java.util.Objects.equals(apiVIP, that.apiVIP)) return false;

    if (!java.util.Objects.equals(apiVIPs, that.apiVIPs)) return false;

    if (!java.util.Objects.equals(cloud, that.cloud)) return false;

    if (!java.util.Objects.equals(clusterOSImage, that.clusterOSImage)) return false;

    if (!java.util.Objects.equals(clusterOSImageProperties, that.clusterOSImageProperties)) return false;

    if (!java.util.Objects.equals(computeFlavor, that.computeFlavor)) return false;

    if (!java.util.Objects.equals(defaultMachinePlatform, that.defaultMachinePlatform)) return false;

    if (!java.util.Objects.equals(externalDNS, that.externalDNS)) return false;

    if (!java.util.Objects.equals(externalNetwork, that.externalNetwork)) return false;

    if (!java.util.Objects.equals(ingressFloatingIP, that.ingressFloatingIP)) return false;

    if (!java.util.Objects.equals(ingressVIP, that.ingressVIP)) return false;

    if (!java.util.Objects.equals(ingressVIPs, that.ingressVIPs)) return false;

    if (!java.util.Objects.equals(lbFloatingIP, that.lbFloatingIP)) return false;

    if (!java.util.Objects.equals(loadBalancer, that.loadBalancer)) return false;

    if (!java.util.Objects.equals(machinesSubnet, that.machinesSubnet)) return false;

    if (!java.util.Objects.equals(octaviaSupport, that.octaviaSupport)) return false;

    if (!java.util.Objects.equals(region, that.region)) return false;

    if (!java.util.Objects.equals(trunkSupport, that.trunkSupport)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiFloatingIP,  apiVIP,  apiVIPs,  cloud,  clusterOSImage,  clusterOSImageProperties,  computeFlavor,  defaultMachinePlatform,  externalDNS,  externalNetwork,  ingressFloatingIP,  ingressVIP,  ingressVIPs,  lbFloatingIP,  loadBalancer,  machinesSubnet,  octaviaSupport,  region,  trunkSupport,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiFloatingIP != null) { sb.append("apiFloatingIP:"); sb.append(apiFloatingIP + ","); }
    if (apiVIP != null) { sb.append("apiVIP:"); sb.append(apiVIP + ","); }
    if (apiVIPs != null && !apiVIPs.isEmpty()) { sb.append("apiVIPs:"); sb.append(apiVIPs + ","); }
    if (cloud != null) { sb.append("cloud:"); sb.append(cloud + ","); }
    if (clusterOSImage != null) { sb.append("clusterOSImage:"); sb.append(clusterOSImage + ","); }
    if (clusterOSImageProperties != null && !clusterOSImageProperties.isEmpty()) { sb.append("clusterOSImageProperties:"); sb.append(clusterOSImageProperties + ","); }
    if (computeFlavor != null) { sb.append("computeFlavor:"); sb.append(computeFlavor + ","); }
    if (defaultMachinePlatform != null) { sb.append("defaultMachinePlatform:"); sb.append(defaultMachinePlatform + ","); }
    if (externalDNS != null && !externalDNS.isEmpty()) { sb.append("externalDNS:"); sb.append(externalDNS + ","); }
    if (externalNetwork != null) { sb.append("externalNetwork:"); sb.append(externalNetwork + ","); }
    if (ingressFloatingIP != null) { sb.append("ingressFloatingIP:"); sb.append(ingressFloatingIP + ","); }
    if (ingressVIP != null) { sb.append("ingressVIP:"); sb.append(ingressVIP + ","); }
    if (ingressVIPs != null && !ingressVIPs.isEmpty()) { sb.append("ingressVIPs:"); sb.append(ingressVIPs + ","); }
    if (lbFloatingIP != null) { sb.append("lbFloatingIP:"); sb.append(lbFloatingIP + ","); }
    if (loadBalancer != null) { sb.append("loadBalancer:"); sb.append(loadBalancer + ","); }
    if (machinesSubnet != null) { sb.append("machinesSubnet:"); sb.append(machinesSubnet + ","); }
    if (octaviaSupport != null) { sb.append("octaviaSupport:"); sb.append(octaviaSupport + ","); }
    if (region != null) { sb.append("region:"); sb.append(region + ","); }
    if (trunkSupport != null) { sb.append("trunkSupport:"); sb.append(trunkSupport + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class DefaultMachinePlatformNested<N> extends MachinePoolFluent<DefaultMachinePlatformNested<N>> implements Nested<N>{
    DefaultMachinePlatformNested(MachinePool item) {
      this.builder = new MachinePoolBuilder(this, item);
    }
    MachinePoolBuilder builder;
    public N and() {
      return (N) PlatformFluent.this.withDefaultMachinePlatform(builder.build());
    }
    public N endDefaultMachinePlatform() {
      return and();
    }
    
  }
  
}