package io.fabric8.openshift.api.model.installer.openstack.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RootVolumeBuilder extends RootVolumeFluent<RootVolumeBuilder> implements VisitableBuilder<RootVolume,RootVolumeBuilder>{
  public RootVolumeBuilder() {
    this(false);
  }
  public RootVolumeBuilder(Boolean validationEnabled) {
    this(new RootVolume(), validationEnabled);
  }
  public RootVolumeBuilder(RootVolumeFluent<?> fluent) {
    this(fluent, false);
  }
  public RootVolumeBuilder(RootVolumeFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RootVolume(), validationEnabled);
  }
  public RootVolumeBuilder(RootVolumeFluent<?> fluent,RootVolume instance) {
    this(fluent, instance, false);
  }
  public RootVolumeBuilder(RootVolumeFluent<?> fluent,RootVolume instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new RootVolume());

    if (instance != null) {
      fluent.withSize(instance.getSize());
      fluent.withType(instance.getType());
      fluent.withZones(instance.getZones());
      fluent.withSize(instance.getSize());
      fluent.withType(instance.getType());
      fluent.withZones(instance.getZones());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public RootVolumeBuilder(RootVolume instance) {
    this(instance,false);
  }
  public RootVolumeBuilder(RootVolume instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new RootVolume());

    if (instance != null) {
      this.withSize(instance.getSize());
      this.withType(instance.getType());
      this.withZones(instance.getZones());
      this.withSize(instance.getSize());
      this.withType(instance.getType());
      this.withZones(instance.getZones());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  RootVolumeFluent<?> fluent;
  Boolean validationEnabled;
  public RootVolume build() {
    RootVolume buildable = new RootVolume(fluent.getSize(),fluent.getType(),fluent.getZones());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}