package io.fabric8.openshift.api.model.installer.powervs.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PlatformBuilder extends PlatformFluent<PlatformBuilder> implements VisitableBuilder<Platform,PlatformBuilder>{
  public PlatformBuilder() {
    this(false);
  }
  public PlatformBuilder(Boolean validationEnabled) {
    this(new Platform(), validationEnabled);
  }
  public PlatformBuilder(PlatformFluent<?> fluent) {
    this(fluent, false);
  }
  public PlatformBuilder(PlatformFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Platform(), validationEnabled);
  }
  public PlatformBuilder(PlatformFluent<?> fluent,Platform instance) {
    this(fluent, instance, false);
  }
  public PlatformBuilder(PlatformFluent<?> fluent,Platform instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Platform());

    if (instance != null) {
      fluent.withCloudConnectionName(instance.getCloudConnectionName());
      fluent.withClusterOSImage(instance.getClusterOSImage());
      fluent.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
      fluent.withPowervsResourceGroup(instance.getPowervsResourceGroup());
      fluent.withPvsNetworkName(instance.getPvsNetworkName());
      fluent.withRegion(instance.getRegion());
      fluent.withServiceInstanceID(instance.getServiceInstanceID());
      fluent.withUserID(instance.getUserID());
      fluent.withVpcName(instance.getVpcName());
      fluent.withVpcRegion(instance.getVpcRegion());
      fluent.withVpcSubnets(instance.getVpcSubnets());
      fluent.withZone(instance.getZone());
      fluent.withCloudConnectionName(instance.getCloudConnectionName());
      fluent.withClusterOSImage(instance.getClusterOSImage());
      fluent.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
      fluent.withPowervsResourceGroup(instance.getPowervsResourceGroup());
      fluent.withPvsNetworkName(instance.getPvsNetworkName());
      fluent.withRegion(instance.getRegion());
      fluent.withServiceInstanceID(instance.getServiceInstanceID());
      fluent.withUserID(instance.getUserID());
      fluent.withVpcName(instance.getVpcName());
      fluent.withVpcRegion(instance.getVpcRegion());
      fluent.withVpcSubnets(instance.getVpcSubnets());
      fluent.withZone(instance.getZone());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PlatformBuilder(Platform instance) {
    this(instance,false);
  }
  public PlatformBuilder(Platform instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Platform());

    if (instance != null) {
      this.withCloudConnectionName(instance.getCloudConnectionName());
      this.withClusterOSImage(instance.getClusterOSImage());
      this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
      this.withPowervsResourceGroup(instance.getPowervsResourceGroup());
      this.withPvsNetworkName(instance.getPvsNetworkName());
      this.withRegion(instance.getRegion());
      this.withServiceInstanceID(instance.getServiceInstanceID());
      this.withUserID(instance.getUserID());
      this.withVpcName(instance.getVpcName());
      this.withVpcRegion(instance.getVpcRegion());
      this.withVpcSubnets(instance.getVpcSubnets());
      this.withZone(instance.getZone());
      this.withCloudConnectionName(instance.getCloudConnectionName());
      this.withClusterOSImage(instance.getClusterOSImage());
      this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
      this.withPowervsResourceGroup(instance.getPowervsResourceGroup());
      this.withPvsNetworkName(instance.getPvsNetworkName());
      this.withRegion(instance.getRegion());
      this.withServiceInstanceID(instance.getServiceInstanceID());
      this.withUserID(instance.getUserID());
      this.withVpcName(instance.getVpcName());
      this.withVpcRegion(instance.getVpcRegion());
      this.withVpcSubnets(instance.getVpcSubnets());
      this.withZone(instance.getZone());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PlatformFluent<?> fluent;
  Boolean validationEnabled;
  public Platform build() {
    Platform buildable = new Platform(fluent.getCloudConnectionName(),fluent.getClusterOSImage(),fluent.buildDefaultMachinePlatform(),fluent.getPowervsResourceGroup(),fluent.getPvsNetworkName(),fluent.getRegion(),fluent.getServiceInstanceID(),fluent.getUserID(),fluent.getVpcName(),fluent.getVpcRegion(),fluent.getVpcSubnets(),fluent.getZone());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}