package io.fabric8.openshift.api.model.installer.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CapabilitiesBuilder extends CapabilitiesFluent<CapabilitiesBuilder> implements VisitableBuilder<Capabilities,CapabilitiesBuilder>{
  public CapabilitiesBuilder() {
    this(false);
  }
  public CapabilitiesBuilder(Boolean validationEnabled) {
    this(new Capabilities(), validationEnabled);
  }
  public CapabilitiesBuilder(CapabilitiesFluent<?> fluent) {
    this(fluent, false);
  }
  public CapabilitiesBuilder(CapabilitiesFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Capabilities(), validationEnabled);
  }
  public CapabilitiesBuilder(CapabilitiesFluent<?> fluent,Capabilities instance) {
    this(fluent, instance, false);
  }
  public CapabilitiesBuilder(CapabilitiesFluent<?> fluent,Capabilities instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Capabilities());

    if (instance != null) {
      fluent.withAdditionalEnabledCapabilities(instance.getAdditionalEnabledCapabilities());
      fluent.withBaselineCapabilitySet(instance.getBaselineCapabilitySet());
      fluent.withAdditionalEnabledCapabilities(instance.getAdditionalEnabledCapabilities());
      fluent.withBaselineCapabilitySet(instance.getBaselineCapabilitySet());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CapabilitiesBuilder(Capabilities instance) {
    this(instance,false);
  }
  public CapabilitiesBuilder(Capabilities instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Capabilities());

    if (instance != null) {
      this.withAdditionalEnabledCapabilities(instance.getAdditionalEnabledCapabilities());
      this.withBaselineCapabilitySet(instance.getBaselineCapabilitySet());
      this.withAdditionalEnabledCapabilities(instance.getAdditionalEnabledCapabilities());
      this.withBaselineCapabilitySet(instance.getBaselineCapabilitySet());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  CapabilitiesFluent<?> fluent;
  Boolean validationEnabled;
  public Capabilities build() {
    Capabilities buildable = new Capabilities(fluent.getAdditionalEnabledCapabilities(),fluent.getBaselineCapabilitySet());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}