package io.fabric8.openshift.api.model.installer.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageContentSourceBuilder extends ImageContentSourceFluent<ImageContentSourceBuilder> implements VisitableBuilder<ImageContentSource,ImageContentSourceBuilder>{
  public ImageContentSourceBuilder() {
    this(false);
  }
  public ImageContentSourceBuilder(Boolean validationEnabled) {
    this(new ImageContentSource(), validationEnabled);
  }
  public ImageContentSourceBuilder(ImageContentSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageContentSourceBuilder(ImageContentSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ImageContentSource(), validationEnabled);
  }
  public ImageContentSourceBuilder(ImageContentSourceFluent<?> fluent,ImageContentSource instance) {
    this(fluent, instance, false);
  }
  public ImageContentSourceBuilder(ImageContentSourceFluent<?> fluent,ImageContentSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ImageContentSource());

    if (instance != null) {
      fluent.withMirrors(instance.getMirrors());
      fluent.withSource(instance.getSource());
      fluent.withMirrors(instance.getMirrors());
      fluent.withSource(instance.getSource());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ImageContentSourceBuilder(ImageContentSource instance) {
    this(instance,false);
  }
  public ImageContentSourceBuilder(ImageContentSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ImageContentSource());

    if (instance != null) {
      this.withMirrors(instance.getMirrors());
      this.withSource(instance.getSource());
      this.withMirrors(instance.getMirrors());
      this.withSource(instance.getSource());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ImageContentSourceFluent<?> fluent;
  Boolean validationEnabled;
  public ImageContentSource build() {
    ImageContentSource buildable = new ImageContentSource(fluent.getMirrors(),fluent.getSource());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}