package io.fabric8.openshift.api.model.installer.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ProxyBuilder extends ProxyFluent<ProxyBuilder> implements VisitableBuilder<Proxy,ProxyBuilder>{
  public ProxyBuilder() {
    this(false);
  }
  public ProxyBuilder(Boolean validationEnabled) {
    this(new Proxy(), validationEnabled);
  }
  public ProxyBuilder(ProxyFluent<?> fluent) {
    this(fluent, false);
  }
  public ProxyBuilder(ProxyFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Proxy(), validationEnabled);
  }
  public ProxyBuilder(ProxyFluent<?> fluent,Proxy instance) {
    this(fluent, instance, false);
  }
  public ProxyBuilder(ProxyFluent<?> fluent,Proxy instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Proxy());

    if (instance != null) {
      fluent.withHttpProxy(instance.getHttpProxy());
      fluent.withHttpsProxy(instance.getHttpsProxy());
      fluent.withNoProxy(instance.getNoProxy());
      fluent.withHttpProxy(instance.getHttpProxy());
      fluent.withHttpsProxy(instance.getHttpsProxy());
      fluent.withNoProxy(instance.getNoProxy());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ProxyBuilder(Proxy instance) {
    this(instance,false);
  }
  public ProxyBuilder(Proxy instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Proxy());

    if (instance != null) {
      this.withHttpProxy(instance.getHttpProxy());
      this.withHttpsProxy(instance.getHttpsProxy());
      this.withNoProxy(instance.getNoProxy());
      this.withHttpProxy(instance.getHttpProxy());
      this.withHttpsProxy(instance.getHttpsProxy());
      this.withNoProxy(instance.getNoProxy());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ProxyFluent<?> fluent;
  Boolean validationEnabled;
  public Proxy build() {
    Proxy buildable = new Proxy(fluent.getHttpProxy(),fluent.getHttpsProxy(),fluent.getNoProxy());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}