package io.fabric8.openshift.api.model.installer.vsphere.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class VCenterBuilder extends VCenterFluent<VCenterBuilder> implements VisitableBuilder<VCenter,VCenterBuilder>{
  public VCenterBuilder() {
    this(false);
  }
  public VCenterBuilder(Boolean validationEnabled) {
    this(new VCenter(), validationEnabled);
  }
  public VCenterBuilder(VCenterFluent<?> fluent) {
    this(fluent, false);
  }
  public VCenterBuilder(VCenterFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new VCenter(), validationEnabled);
  }
  public VCenterBuilder(VCenterFluent<?> fluent,VCenter instance) {
    this(fluent, instance, false);
  }
  public VCenterBuilder(VCenterFluent<?> fluent,VCenter instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new VCenter());

    if (instance != null) {
      fluent.withDatacenters(instance.getDatacenters());
      fluent.withPassword(instance.getPassword());
      fluent.withPort(instance.getPort());
      fluent.withServer(instance.getServer());
      fluent.withUser(instance.getUser());
      fluent.withDatacenters(instance.getDatacenters());
      fluent.withPassword(instance.getPassword());
      fluent.withPort(instance.getPort());
      fluent.withServer(instance.getServer());
      fluent.withUser(instance.getUser());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public VCenterBuilder(VCenter instance) {
    this(instance,false);
  }
  public VCenterBuilder(VCenter instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new VCenter());

    if (instance != null) {
      this.withDatacenters(instance.getDatacenters());
      this.withPassword(instance.getPassword());
      this.withPort(instance.getPort());
      this.withServer(instance.getServer());
      this.withUser(instance.getUser());
      this.withDatacenters(instance.getDatacenters());
      this.withPassword(instance.getPassword());
      this.withPort(instance.getPort());
      this.withServer(instance.getServer());
      this.withUser(instance.getUser());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  VCenterFluent<?> fluent;
  Boolean validationEnabled;
  public VCenter build() {
    VCenter buildable = new VCenter(fluent.getDatacenters(),fluent.getPassword(),fluent.getPort(),fluent.getServer(),fluent.getUser());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}