package io.fabric8.openshift.api.model.installer.azure.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DiskEncryptionSetBuilder extends DiskEncryptionSetFluent<DiskEncryptionSetBuilder> implements VisitableBuilder<DiskEncryptionSet,DiskEncryptionSetBuilder>{
  public DiskEncryptionSetBuilder() {
    this(false);
  }
  public DiskEncryptionSetBuilder(Boolean validationEnabled) {
    this(new DiskEncryptionSet(), validationEnabled);
  }
  public DiskEncryptionSetBuilder(DiskEncryptionSetFluent<?> fluent) {
    this(fluent, false);
  }
  public DiskEncryptionSetBuilder(DiskEncryptionSetFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DiskEncryptionSet(), validationEnabled);
  }
  public DiskEncryptionSetBuilder(DiskEncryptionSetFluent<?> fluent,DiskEncryptionSet instance) {
    this(fluent, instance, false);
  }
  public DiskEncryptionSetBuilder(DiskEncryptionSetFluent<?> fluent,DiskEncryptionSet instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new DiskEncryptionSet());

    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withResourceGroup(instance.getResourceGroup());
      fluent.withSubscriptionId(instance.getSubscriptionId());
      fluent.withName(instance.getName());
      fluent.withResourceGroup(instance.getResourceGroup());
      fluent.withSubscriptionId(instance.getSubscriptionId());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DiskEncryptionSetBuilder(DiskEncryptionSet instance) {
    this(instance,false);
  }
  public DiskEncryptionSetBuilder(DiskEncryptionSet instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new DiskEncryptionSet());

    if (instance != null) {
      this.withName(instance.getName());
      this.withResourceGroup(instance.getResourceGroup());
      this.withSubscriptionId(instance.getSubscriptionId());
      this.withName(instance.getName());
      this.withResourceGroup(instance.getResourceGroup());
      this.withSubscriptionId(instance.getSubscriptionId());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  DiskEncryptionSetFluent<?> fluent;
  Boolean validationEnabled;
  public DiskEncryptionSet build() {
    DiskEncryptionSet buildable = new DiskEncryptionSet(fluent.getName(),fluent.getResourceGroup(),fluent.getSubscriptionId());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}