package io.fabric8.openshift.api.model.installer.azure.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MachinePoolBuilder extends MachinePoolFluent<MachinePoolBuilder> implements VisitableBuilder<MachinePool,MachinePoolBuilder>{
  public MachinePoolBuilder() {
    this(false);
  }
  public MachinePoolBuilder(Boolean validationEnabled) {
    this(new MachinePool(), validationEnabled);
  }
  public MachinePoolBuilder(MachinePoolFluent<?> fluent) {
    this(fluent, false);
  }
  public MachinePoolBuilder(MachinePoolFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MachinePool(), validationEnabled);
  }
  public MachinePoolBuilder(MachinePoolFluent<?> fluent,MachinePool instance) {
    this(fluent, instance, false);
  }
  public MachinePoolBuilder(MachinePoolFluent<?> fluent,MachinePool instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new MachinePool());

    if (instance != null) {
      fluent.withEncryptionAtHost(instance.getEncryptionAtHost());
      fluent.withOsDisk(instance.getOsDisk());
      fluent.withOsImage(instance.getOsImage());
      fluent.withType(instance.getType());
      fluent.withUltraSSDCapability(instance.getUltraSSDCapability());
      fluent.withVmNetworkingType(instance.getVmNetworkingType());
      fluent.withZones(instance.getZones());
      fluent.withEncryptionAtHost(instance.getEncryptionAtHost());
      fluent.withOsDisk(instance.getOsDisk());
      fluent.withOsImage(instance.getOsImage());
      fluent.withType(instance.getType());
      fluent.withUltraSSDCapability(instance.getUltraSSDCapability());
      fluent.withVmNetworkingType(instance.getVmNetworkingType());
      fluent.withZones(instance.getZones());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public MachinePoolBuilder(MachinePool instance) {
    this(instance,false);
  }
  public MachinePoolBuilder(MachinePool instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new MachinePool());

    if (instance != null) {
      this.withEncryptionAtHost(instance.getEncryptionAtHost());
      this.withOsDisk(instance.getOsDisk());
      this.withOsImage(instance.getOsImage());
      this.withType(instance.getType());
      this.withUltraSSDCapability(instance.getUltraSSDCapability());
      this.withVmNetworkingType(instance.getVmNetworkingType());
      this.withZones(instance.getZones());
      this.withEncryptionAtHost(instance.getEncryptionAtHost());
      this.withOsDisk(instance.getOsDisk());
      this.withOsImage(instance.getOsImage());
      this.withType(instance.getType());
      this.withUltraSSDCapability(instance.getUltraSSDCapability());
      this.withVmNetworkingType(instance.getVmNetworkingType());
      this.withZones(instance.getZones());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  MachinePoolFluent<?> fluent;
  Boolean validationEnabled;
  public MachinePool build() {
    MachinePool buildable = new MachinePool(fluent.getEncryptionAtHost(),fluent.buildOsDisk(),fluent.buildOsImage(),fluent.getType(),fluent.getUltraSSDCapability(),fluent.getVmNetworkingType(),fluent.getZones());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}