package io.fabric8.openshift.api.model.installer.azure.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OSDiskBuilder extends OSDiskFluent<OSDiskBuilder> implements VisitableBuilder<OSDisk,OSDiskBuilder>{
  public OSDiskBuilder() {
    this(false);
  }
  public OSDiskBuilder(Boolean validationEnabled) {
    this(new OSDisk(), validationEnabled);
  }
  public OSDiskBuilder(OSDiskFluent<?> fluent) {
    this(fluent, false);
  }
  public OSDiskBuilder(OSDiskFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OSDisk(), validationEnabled);
  }
  public OSDiskBuilder(OSDiskFluent<?> fluent,OSDisk instance) {
    this(fluent, instance, false);
  }
  public OSDiskBuilder(OSDiskFluent<?> fluent,OSDisk instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new OSDisk());

    if (instance != null) {
      fluent.withDiskEncryptionSet(instance.getDiskEncryptionSet());
      fluent.withDiskSizeGB(instance.getDiskSizeGB());
      fluent.withDiskType(instance.getDiskType());
      fluent.withDiskEncryptionSet(instance.getDiskEncryptionSet());
      fluent.withDiskSizeGB(instance.getDiskSizeGB());
      fluent.withDiskType(instance.getDiskType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public OSDiskBuilder(OSDisk instance) {
    this(instance,false);
  }
  public OSDiskBuilder(OSDisk instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new OSDisk());

    if (instance != null) {
      this.withDiskEncryptionSet(instance.getDiskEncryptionSet());
      this.withDiskSizeGB(instance.getDiskSizeGB());
      this.withDiskType(instance.getDiskType());
      this.withDiskEncryptionSet(instance.getDiskEncryptionSet());
      this.withDiskSizeGB(instance.getDiskSizeGB());
      this.withDiskType(instance.getDiskType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  OSDiskFluent<?> fluent;
  Boolean validationEnabled;
  public OSDisk build() {
    OSDisk buildable = new OSDisk(fluent.buildDiskEncryptionSet(),fluent.getDiskSizeGB(),fluent.getDiskType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}