package io.fabric8.openshift.api.model.installer.baremetal.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import com.fasterxml.jackson.databind.JsonNode;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class HostFluent<A extends HostFluent<A>> extends BaseFluent<A>{
  public HostFluent() {
  }
  public HostFluent(Host instance) {
    instance = (instance != null ? instance : new Host());

    if (instance != null) {
      this.withBmc(instance.getBmc());
      this.withBootMACAddress(instance.getBootMACAddress());
      this.withBootMode(instance.getBootMode());
      this.withHardwareProfile(instance.getHardwareProfile());
      this.withName(instance.getName());
      this.withNetworkConfig(instance.getNetworkConfig());
      this.withRole(instance.getRole());
      this.withRootDeviceHints(instance.getRootDeviceHints());
      this.withBmc(instance.getBmc());
      this.withBootMACAddress(instance.getBootMACAddress());
      this.withBootMode(instance.getBootMode());
      this.withHardwareProfile(instance.getHardwareProfile());
      this.withName(instance.getName());
      this.withNetworkConfig(instance.getNetworkConfig());
      this.withRole(instance.getRole());
      this.withRootDeviceHints(instance.getRootDeviceHints());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private BMCBuilder bmc;
  private String bootMACAddress;
  private String bootMode;
  private String hardwareProfile;
  private String name;
  private JsonNode networkConfig;
  private String role;
  private RootDeviceHintsBuilder rootDeviceHints;
  private Map<String,Object> additionalProperties;
  public BMC buildBmc() {
    return this.bmc!=null ?this.bmc.build():null;
  }
  public A withBmc(BMC bmc) {
    _visitables.get("bmc").remove(this.bmc);
    if (bmc!=null){ this.bmc= new BMCBuilder(bmc); _visitables.get("bmc").add(this.bmc);} else { this.bmc = null; _visitables.get("bmc").remove(this.bmc); } return (A) this;
  }
  public boolean hasBmc() {
    return this.bmc != null;
  }
  public A withNewBmc(String address,Boolean disableCertificateVerification,String password,String username) {
    return (A)withBmc(new BMC(address, disableCertificateVerification, password, username));
  }
  public BmcNested<A> withNewBmc() {
    return new BmcNested(null);
  }
  public BmcNested<A> withNewBmcLike(BMC item) {
    return new BmcNested(item);
  }
  public BmcNested<A> editBmc() {
    return withNewBmcLike(java.util.Optional.ofNullable(buildBmc()).orElse(null));
  }
  public BmcNested<A> editOrNewBmc() {
    return withNewBmcLike(java.util.Optional.ofNullable(buildBmc()).orElse(new BMCBuilder().build()));
  }
  public BmcNested<A> editOrNewBmcLike(BMC item) {
    return withNewBmcLike(java.util.Optional.ofNullable(buildBmc()).orElse(item));
  }
  public String getBootMACAddress() {
    return this.bootMACAddress;
  }
  public A withBootMACAddress(String bootMACAddress) {
    this.bootMACAddress=bootMACAddress; return (A) this;
  }
  public boolean hasBootMACAddress() {
    return this.bootMACAddress != null;
  }
  public String getBootMode() {
    return this.bootMode;
  }
  public A withBootMode(String bootMode) {
    this.bootMode=bootMode; return (A) this;
  }
  public boolean hasBootMode() {
    return this.bootMode != null;
  }
  public String getHardwareProfile() {
    return this.hardwareProfile;
  }
  public A withHardwareProfile(String hardwareProfile) {
    this.hardwareProfile=hardwareProfile; return (A) this;
  }
  public boolean hasHardwareProfile() {
    return this.hardwareProfile != null;
  }
  public String getName() {
    return this.name;
  }
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  public boolean hasName() {
    return this.name != null;
  }
  public JsonNode getNetworkConfig() {
    return this.networkConfig;
  }
  public A withNetworkConfig(JsonNode networkConfig) {
    this.networkConfig=networkConfig; return (A) this;
  }
  public boolean hasNetworkConfig() {
    return this.networkConfig != null;
  }
  public String getRole() {
    return this.role;
  }
  public A withRole(String role) {
    this.role=role; return (A) this;
  }
  public boolean hasRole() {
    return this.role != null;
  }
  public RootDeviceHints buildRootDeviceHints() {
    return this.rootDeviceHints!=null ?this.rootDeviceHints.build():null;
  }
  public A withRootDeviceHints(RootDeviceHints rootDeviceHints) {
    _visitables.get("rootDeviceHints").remove(this.rootDeviceHints);
    if (rootDeviceHints!=null){ this.rootDeviceHints= new RootDeviceHintsBuilder(rootDeviceHints); _visitables.get("rootDeviceHints").add(this.rootDeviceHints);} else { this.rootDeviceHints = null; _visitables.get("rootDeviceHints").remove(this.rootDeviceHints); } return (A) this;
  }
  public boolean hasRootDeviceHints() {
    return this.rootDeviceHints != null;
  }
  public RootDeviceHintsNested<A> withNewRootDeviceHints() {
    return new RootDeviceHintsNested(null);
  }
  public RootDeviceHintsNested<A> withNewRootDeviceHintsLike(RootDeviceHints item) {
    return new RootDeviceHintsNested(item);
  }
  public RootDeviceHintsNested<A> editRootDeviceHints() {
    return withNewRootDeviceHintsLike(java.util.Optional.ofNullable(buildRootDeviceHints()).orElse(null));
  }
  public RootDeviceHintsNested<A> editOrNewRootDeviceHints() {
    return withNewRootDeviceHintsLike(java.util.Optional.ofNullable(buildRootDeviceHints()).orElse(new RootDeviceHintsBuilder().build()));
  }
  public RootDeviceHintsNested<A> editOrNewRootDeviceHintsLike(RootDeviceHints item) {
    return withNewRootDeviceHintsLike(java.util.Optional.ofNullable(buildRootDeviceHints()).orElse(item));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    HostFluent that = (HostFluent) o;
    if (!java.util.Objects.equals(bmc, that.bmc)) return false;

    if (!java.util.Objects.equals(bootMACAddress, that.bootMACAddress)) return false;

    if (!java.util.Objects.equals(bootMode, that.bootMode)) return false;

    if (!java.util.Objects.equals(hardwareProfile, that.hardwareProfile)) return false;

    if (!java.util.Objects.equals(name, that.name)) return false;

    if (!java.util.Objects.equals(networkConfig, that.networkConfig)) return false;

    if (!java.util.Objects.equals(role, that.role)) return false;

    if (!java.util.Objects.equals(rootDeviceHints, that.rootDeviceHints)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(bmc,  bootMACAddress,  bootMode,  hardwareProfile,  name,  networkConfig,  role,  rootDeviceHints,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (bmc != null) { sb.append("bmc:"); sb.append(bmc + ","); }
    if (bootMACAddress != null) { sb.append("bootMACAddress:"); sb.append(bootMACAddress + ","); }
    if (bootMode != null) { sb.append("bootMode:"); sb.append(bootMode + ","); }
    if (hardwareProfile != null) { sb.append("hardwareProfile:"); sb.append(hardwareProfile + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (networkConfig != null) { sb.append("networkConfig:"); sb.append(networkConfig + ","); }
    if (role != null) { sb.append("role:"); sb.append(role + ","); }
    if (rootDeviceHints != null) { sb.append("rootDeviceHints:"); sb.append(rootDeviceHints + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class BmcNested<N> extends BMCFluent<BmcNested<N>> implements Nested<N>{
    BmcNested(BMC item) {
      this.builder = new BMCBuilder(this, item);
    }
    BMCBuilder builder;
    public N and() {
      return (N) HostFluent.this.withBmc(builder.build());
    }
    public N endBmc() {
      return and();
    }
    
  }
  public class RootDeviceHintsNested<N> extends RootDeviceHintsFluent<RootDeviceHintsNested<N>> implements Nested<N>{
    RootDeviceHintsNested(RootDeviceHints item) {
      this.builder = new RootDeviceHintsBuilder(this, item);
    }
    RootDeviceHintsBuilder builder;
    public N and() {
      return (N) HostFluent.this.withRootDeviceHints(builder.build());
    }
    public N endRootDeviceHints() {
      return and();
    }
    
  }
  
}