package io.fabric8.openshift.api.model.installer.ibmcloud.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DedicatedHostBuilder extends DedicatedHostFluent<DedicatedHostBuilder> implements VisitableBuilder<DedicatedHost,DedicatedHostBuilder>{
  public DedicatedHostBuilder() {
    this(false);
  }
  public DedicatedHostBuilder(Boolean validationEnabled) {
    this(new DedicatedHost(), validationEnabled);
  }
  public DedicatedHostBuilder(DedicatedHostFluent<?> fluent) {
    this(fluent, false);
  }
  public DedicatedHostBuilder(DedicatedHostFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DedicatedHost(), validationEnabled);
  }
  public DedicatedHostBuilder(DedicatedHostFluent<?> fluent,DedicatedHost instance) {
    this(fluent, instance, false);
  }
  public DedicatedHostBuilder(DedicatedHostFluent<?> fluent,DedicatedHost instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new DedicatedHost());

    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withProfile(instance.getProfile());
      fluent.withName(instance.getName());
      fluent.withProfile(instance.getProfile());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DedicatedHostBuilder(DedicatedHost instance) {
    this(instance,false);
  }
  public DedicatedHostBuilder(DedicatedHost instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new DedicatedHost());

    if (instance != null) {
      this.withName(instance.getName());
      this.withProfile(instance.getProfile());
      this.withName(instance.getName());
      this.withProfile(instance.getProfile());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  DedicatedHostFluent<?> fluent;
  Boolean validationEnabled;
  public DedicatedHost build() {
    DedicatedHost buildable = new DedicatedHost(fluent.getName(),fluent.getProfile());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}