package io.fabric8.openshift.api.model.installer.libvirt.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PlatformBuilder extends PlatformFluent<PlatformBuilder> implements VisitableBuilder<Platform,PlatformBuilder>{
  public PlatformBuilder() {
    this(false);
  }
  public PlatformBuilder(Boolean validationEnabled) {
    this(new Platform(), validationEnabled);
  }
  public PlatformBuilder(PlatformFluent<?> fluent) {
    this(fluent, false);
  }
  public PlatformBuilder(PlatformFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Platform(), validationEnabled);
  }
  public PlatformBuilder(PlatformFluent<?> fluent,Platform instance) {
    this(fluent, instance, false);
  }
  public PlatformBuilder(PlatformFluent<?> fluent,Platform instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Platform());

    if (instance != null) {
      fluent.withUri(instance.getUri());
      fluent.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
      fluent.withNetwork(instance.getNetwork());
      fluent.withUri(instance.getUri());
      fluent.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
      fluent.withNetwork(instance.getNetwork());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PlatformBuilder(Platform instance) {
    this(instance,false);
  }
  public PlatformBuilder(Platform instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Platform());

    if (instance != null) {
      this.withUri(instance.getUri());
      this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
      this.withNetwork(instance.getNetwork());
      this.withUri(instance.getUri());
      this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
      this.withNetwork(instance.getNetwork());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PlatformFluent<?> fluent;
  Boolean validationEnabled;
  public Platform build() {
    Platform buildable = new Platform(fluent.getUri(),fluent.buildDefaultMachinePlatform(),fluent.buildNetwork());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}