package io.fabric8.openshift.api.model.installer.nutanix.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PlatformBuilder extends PlatformFluent<PlatformBuilder> implements VisitableBuilder<Platform,PlatformBuilder>{
  public PlatformBuilder() {
    this(false);
  }
  public PlatformBuilder(Boolean validationEnabled) {
    this(new Platform(), validationEnabled);
  }
  public PlatformBuilder(PlatformFluent<?> fluent) {
    this(fluent, false);
  }
  public PlatformBuilder(PlatformFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Platform(), validationEnabled);
  }
  public PlatformBuilder(PlatformFluent<?> fluent,Platform instance) {
    this(fluent, instance, false);
  }
  public PlatformBuilder(PlatformFluent<?> fluent,Platform instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Platform());

    if (instance != null) {
      fluent.withApiVIP(instance.getApiVIP());
      fluent.withApiVIPs(instance.getApiVIPs());
      fluent.withClusterOSImage(instance.getClusterOSImage());
      fluent.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
      fluent.withIngressVIP(instance.getIngressVIP());
      fluent.withIngressVIPs(instance.getIngressVIPs());
      fluent.withLoadBalancer(instance.getLoadBalancer());
      fluent.withPrismCentral(instance.getPrismCentral());
      fluent.withPrismElements(instance.getPrismElements());
      fluent.withSubnetUUIDs(instance.getSubnetUUIDs());
      fluent.withApiVIP(instance.getApiVIP());
      fluent.withApiVIPs(instance.getApiVIPs());
      fluent.withClusterOSImage(instance.getClusterOSImage());
      fluent.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
      fluent.withIngressVIP(instance.getIngressVIP());
      fluent.withIngressVIPs(instance.getIngressVIPs());
      fluent.withLoadBalancer(instance.getLoadBalancer());
      fluent.withPrismCentral(instance.getPrismCentral());
      fluent.withPrismElements(instance.getPrismElements());
      fluent.withSubnetUUIDs(instance.getSubnetUUIDs());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PlatformBuilder(Platform instance) {
    this(instance,false);
  }
  public PlatformBuilder(Platform instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Platform());

    if (instance != null) {
      this.withApiVIP(instance.getApiVIP());
      this.withApiVIPs(instance.getApiVIPs());
      this.withClusterOSImage(instance.getClusterOSImage());
      this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
      this.withIngressVIP(instance.getIngressVIP());
      this.withIngressVIPs(instance.getIngressVIPs());
      this.withLoadBalancer(instance.getLoadBalancer());
      this.withPrismCentral(instance.getPrismCentral());
      this.withPrismElements(instance.getPrismElements());
      this.withSubnetUUIDs(instance.getSubnetUUIDs());
      this.withApiVIP(instance.getApiVIP());
      this.withApiVIPs(instance.getApiVIPs());
      this.withClusterOSImage(instance.getClusterOSImage());
      this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
      this.withIngressVIP(instance.getIngressVIP());
      this.withIngressVIPs(instance.getIngressVIPs());
      this.withLoadBalancer(instance.getLoadBalancer());
      this.withPrismCentral(instance.getPrismCentral());
      this.withPrismElements(instance.getPrismElements());
      this.withSubnetUUIDs(instance.getSubnetUUIDs());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PlatformFluent<?> fluent;
  Boolean validationEnabled;
  public Platform build() {
    Platform buildable = new Platform(fluent.getApiVIP(),fluent.getApiVIPs(),fluent.getClusterOSImage(),fluent.buildDefaultMachinePlatform(),fluent.getIngressVIP(),fluent.getIngressVIPs(),fluent.getLoadBalancer(),fluent.buildPrismCentral(),fluent.buildPrismElements(),fluent.getSubnetUUIDs());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}