package io.fabric8.openshift.api.model.installer.openstack.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MachinePoolBuilder extends MachinePoolFluent<MachinePoolBuilder> implements VisitableBuilder<MachinePool,MachinePoolBuilder>{
  public MachinePoolBuilder() {
    this(false);
  }
  public MachinePoolBuilder(Boolean validationEnabled) {
    this(new MachinePool(), validationEnabled);
  }
  public MachinePoolBuilder(MachinePoolFluent<?> fluent) {
    this(fluent, false);
  }
  public MachinePoolBuilder(MachinePoolFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MachinePool(), validationEnabled);
  }
  public MachinePoolBuilder(MachinePoolFluent<?> fluent,MachinePool instance) {
    this(fluent, instance, false);
  }
  public MachinePoolBuilder(MachinePoolFluent<?> fluent,MachinePool instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new MachinePool());

    if (instance != null) {
      fluent.withAdditionalNetworkIDs(instance.getAdditionalNetworkIDs());
      fluent.withAdditionalSecurityGroupIDs(instance.getAdditionalSecurityGroupIDs());
      fluent.withFailureDomains(instance.getFailureDomains());
      fluent.withRootVolume(instance.getRootVolume());
      fluent.withServerGroupPolicy(instance.getServerGroupPolicy());
      fluent.withType(instance.getType());
      fluent.withZones(instance.getZones());
      fluent.withAdditionalNetworkIDs(instance.getAdditionalNetworkIDs());
      fluent.withAdditionalSecurityGroupIDs(instance.getAdditionalSecurityGroupIDs());
      fluent.withFailureDomains(instance.getFailureDomains());
      fluent.withRootVolume(instance.getRootVolume());
      fluent.withServerGroupPolicy(instance.getServerGroupPolicy());
      fluent.withType(instance.getType());
      fluent.withZones(instance.getZones());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public MachinePoolBuilder(MachinePool instance) {
    this(instance,false);
  }
  public MachinePoolBuilder(MachinePool instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new MachinePool());

    if (instance != null) {
      this.withAdditionalNetworkIDs(instance.getAdditionalNetworkIDs());
      this.withAdditionalSecurityGroupIDs(instance.getAdditionalSecurityGroupIDs());
      this.withFailureDomains(instance.getFailureDomains());
      this.withRootVolume(instance.getRootVolume());
      this.withServerGroupPolicy(instance.getServerGroupPolicy());
      this.withType(instance.getType());
      this.withZones(instance.getZones());
      this.withAdditionalNetworkIDs(instance.getAdditionalNetworkIDs());
      this.withAdditionalSecurityGroupIDs(instance.getAdditionalSecurityGroupIDs());
      this.withFailureDomains(instance.getFailureDomains());
      this.withRootVolume(instance.getRootVolume());
      this.withServerGroupPolicy(instance.getServerGroupPolicy());
      this.withType(instance.getType());
      this.withZones(instance.getZones());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  MachinePoolFluent<?> fluent;
  Boolean validationEnabled;
  public MachinePool build() {
    MachinePool buildable = new MachinePool(fluent.getAdditionalNetworkIDs(),fluent.getAdditionalSecurityGroupIDs(),fluent.buildFailureDomains(),fluent.buildRootVolume(),fluent.getServerGroupPolicy(),fluent.getType(),fluent.getZones());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}