package io.fabric8.openshift.api.model.installer.openstack.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NamedPortTargetBuilder extends NamedPortTargetFluent<NamedPortTargetBuilder> implements VisitableBuilder<NamedPortTarget,NamedPortTargetBuilder>{
  public NamedPortTargetBuilder() {
    this(false);
  }
  public NamedPortTargetBuilder(Boolean validationEnabled) {
    this(new NamedPortTarget(), validationEnabled);
  }
  public NamedPortTargetBuilder(NamedPortTargetFluent<?> fluent) {
    this(fluent, false);
  }
  public NamedPortTargetBuilder(NamedPortTargetFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NamedPortTarget(), validationEnabled);
  }
  public NamedPortTargetBuilder(NamedPortTargetFluent<?> fluent,NamedPortTarget instance) {
    this(fluent, instance, false);
  }
  public NamedPortTargetBuilder(NamedPortTargetFluent<?> fluent,NamedPortTarget instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new NamedPortTarget());

    if (instance != null) {
      fluent.withFixedIPs(instance.getFixedIPs());
      fluent.withId(instance.getId());
      fluent.withNetwork(instance.getNetwork());
      fluent.withFixedIPs(instance.getFixedIPs());
      fluent.withId(instance.getId());
      fluent.withNetwork(instance.getNetwork());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public NamedPortTargetBuilder(NamedPortTarget instance) {
    this(instance,false);
  }
  public NamedPortTargetBuilder(NamedPortTarget instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new NamedPortTarget());

    if (instance != null) {
      this.withFixedIPs(instance.getFixedIPs());
      this.withId(instance.getId());
      this.withNetwork(instance.getNetwork());
      this.withFixedIPs(instance.getFixedIPs());
      this.withId(instance.getId());
      this.withNetwork(instance.getNetwork());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  NamedPortTargetFluent<?> fluent;
  Boolean validationEnabled;
  public NamedPortTarget build() {
    NamedPortTarget buildable = new NamedPortTarget(fluent.buildFixedIPs(),fluent.getId(),fluent.buildNetwork());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}