package io.fabric8.openshift.api.model.installer.ovirt.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PlatformBuilder extends PlatformFluent<PlatformBuilder> implements VisitableBuilder<Platform,PlatformBuilder>{
  public PlatformBuilder() {
    this(false);
  }
  public PlatformBuilder(Boolean validationEnabled) {
    this(new Platform(), validationEnabled);
  }
  public PlatformBuilder(PlatformFluent<?> fluent) {
    this(fluent, false);
  }
  public PlatformBuilder(PlatformFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Platform(), validationEnabled);
  }
  public PlatformBuilder(PlatformFluent<?> fluent,Platform instance) {
    this(fluent, instance, false);
  }
  public PlatformBuilder(PlatformFluent<?> fluent,Platform instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Platform());

    if (instance != null) {
      fluent.withAffinityGroups(instance.getAffinityGroups());
      fluent.withApiVip(instance.getApiVip());
      fluent.withApiVips(instance.getApiVips());
      fluent.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
      fluent.withIngressVip(instance.getIngressVip());
      fluent.withIngressVips(instance.getIngressVips());
      fluent.withLoadBalancer(instance.getLoadBalancer());
      fluent.withOvirtClusterId(instance.getOvirtClusterId());
      fluent.withOvirtNetworkName(instance.getOvirtNetworkName());
      fluent.withOvirtStorageDomainId(instance.getOvirtStorageDomainId());
      fluent.withVnicProfileID(instance.getVnicProfileID());
      fluent.withAffinityGroups(instance.getAffinityGroups());
      fluent.withApiVip(instance.getApiVip());
      fluent.withApiVips(instance.getApiVips());
      fluent.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
      fluent.withIngressVip(instance.getIngressVip());
      fluent.withIngressVips(instance.getIngressVips());
      fluent.withLoadBalancer(instance.getLoadBalancer());
      fluent.withOvirtClusterId(instance.getOvirtClusterId());
      fluent.withOvirtNetworkName(instance.getOvirtNetworkName());
      fluent.withOvirtStorageDomainId(instance.getOvirtStorageDomainId());
      fluent.withVnicProfileID(instance.getVnicProfileID());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PlatformBuilder(Platform instance) {
    this(instance,false);
  }
  public PlatformBuilder(Platform instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Platform());

    if (instance != null) {
      this.withAffinityGroups(instance.getAffinityGroups());
      this.withApiVip(instance.getApiVip());
      this.withApiVips(instance.getApiVips());
      this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
      this.withIngressVip(instance.getIngressVip());
      this.withIngressVips(instance.getIngressVips());
      this.withLoadBalancer(instance.getLoadBalancer());
      this.withOvirtClusterId(instance.getOvirtClusterId());
      this.withOvirtNetworkName(instance.getOvirtNetworkName());
      this.withOvirtStorageDomainId(instance.getOvirtStorageDomainId());
      this.withVnicProfileID(instance.getVnicProfileID());
      this.withAffinityGroups(instance.getAffinityGroups());
      this.withApiVip(instance.getApiVip());
      this.withApiVips(instance.getApiVips());
      this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
      this.withIngressVip(instance.getIngressVip());
      this.withIngressVips(instance.getIngressVips());
      this.withLoadBalancer(instance.getLoadBalancer());
      this.withOvirtClusterId(instance.getOvirtClusterId());
      this.withOvirtNetworkName(instance.getOvirtNetworkName());
      this.withOvirtStorageDomainId(instance.getOvirtStorageDomainId());
      this.withVnicProfileID(instance.getVnicProfileID());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PlatformFluent<?> fluent;
  Boolean validationEnabled;
  public Platform build() {
    Platform buildable = new Platform(fluent.buildAffinityGroups(),fluent.getApiVip(),fluent.getApiVips(),fluent.buildDefaultMachinePlatform(),fluent.getIngressVip(),fluent.getIngressVips(),fluent.getLoadBalancer(),fluent.getOvirtClusterId(),fluent.getOvirtNetworkName(),fluent.getOvirtStorageDomainId(),fluent.getVnicProfileID());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}