package io.fabric8.openshift.api.model.installer.powervs.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MachinePoolBuilder extends MachinePoolFluent<MachinePoolBuilder> implements VisitableBuilder<MachinePool,MachinePoolBuilder>{
  public MachinePoolBuilder() {
    this(false);
  }
  public MachinePoolBuilder(Boolean validationEnabled) {
    this(new MachinePool(), validationEnabled);
  }
  public MachinePoolBuilder(MachinePoolFluent<?> fluent) {
    this(fluent, false);
  }
  public MachinePoolBuilder(MachinePoolFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MachinePool(), validationEnabled);
  }
  public MachinePoolBuilder(MachinePoolFluent<?> fluent,MachinePool instance) {
    this(fluent, instance, false);
  }
  public MachinePoolBuilder(MachinePoolFluent<?> fluent,MachinePool instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new MachinePool());

    if (instance != null) {
      fluent.withMemoryGiB(instance.getMemoryGiB());
      fluent.withProcType(instance.getProcType());
      fluent.withProcessors(instance.getProcessors());
      fluent.withSysType(instance.getSysType());
      fluent.withVolumeIDs(instance.getVolumeIDs());
      fluent.withMemoryGiB(instance.getMemoryGiB());
      fluent.withProcType(instance.getProcType());
      fluent.withProcessors(instance.getProcessors());
      fluent.withSysType(instance.getSysType());
      fluent.withVolumeIDs(instance.getVolumeIDs());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public MachinePoolBuilder(MachinePool instance) {
    this(instance,false);
  }
  public MachinePoolBuilder(MachinePool instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new MachinePool());

    if (instance != null) {
      this.withMemoryGiB(instance.getMemoryGiB());
      this.withProcType(instance.getProcType());
      this.withProcessors(instance.getProcessors());
      this.withSysType(instance.getSysType());
      this.withVolumeIDs(instance.getVolumeIDs());
      this.withMemoryGiB(instance.getMemoryGiB());
      this.withProcType(instance.getProcType());
      this.withProcessors(instance.getProcessors());
      this.withSysType(instance.getSysType());
      this.withVolumeIDs(instance.getVolumeIDs());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  MachinePoolFluent<?> fluent;
  Boolean validationEnabled;
  public MachinePool build() {
    MachinePool buildable = new MachinePool(fluent.getMemoryGiB(),fluent.getProcType(),fluent.buildProcessors(),fluent.getSysType(),fluent.getVolumeIDs());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}