package io.fabric8.openshift.api.model.installer.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MachinePoolPlatformBuilder extends MachinePoolPlatformFluent<MachinePoolPlatformBuilder> implements VisitableBuilder<MachinePoolPlatform,MachinePoolPlatformBuilder>{
  public MachinePoolPlatformBuilder() {
    this(false);
  }
  public MachinePoolPlatformBuilder(Boolean validationEnabled) {
    this(new MachinePoolPlatform(), validationEnabled);
  }
  public MachinePoolPlatformBuilder(MachinePoolPlatformFluent<?> fluent) {
    this(fluent, false);
  }
  public MachinePoolPlatformBuilder(MachinePoolPlatformFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MachinePoolPlatform(), validationEnabled);
  }
  public MachinePoolPlatformBuilder(MachinePoolPlatformFluent<?> fluent,MachinePoolPlatform instance) {
    this(fluent, instance, false);
  }
  public MachinePoolPlatformBuilder(MachinePoolPlatformFluent<?> fluent,MachinePoolPlatform instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new MachinePoolPlatform());

    if (instance != null) {
      fluent.withAlibabacloud(instance.getAlibabacloud());
      fluent.withAws(instance.getAws());
      fluent.withAzure(instance.getAzure());
      fluent.withBaremetal(instance.getBaremetal());
      fluent.withGcp(instance.getGcp());
      fluent.withIbmcloud(instance.getIbmcloud());
      fluent.withLibvirt(instance.getLibvirt());
      fluent.withNutanix(instance.getNutanix());
      fluent.withOpenstack(instance.getOpenstack());
      fluent.withOvirt(instance.getOvirt());
      fluent.withPowervs(instance.getPowervs());
      fluent.withVsphere(instance.getVsphere());
      fluent.withAlibabacloud(instance.getAlibabacloud());
      fluent.withAws(instance.getAws());
      fluent.withAzure(instance.getAzure());
      fluent.withBaremetal(instance.getBaremetal());
      fluent.withGcp(instance.getGcp());
      fluent.withIbmcloud(instance.getIbmcloud());
      fluent.withLibvirt(instance.getLibvirt());
      fluent.withNutanix(instance.getNutanix());
      fluent.withOpenstack(instance.getOpenstack());
      fluent.withOvirt(instance.getOvirt());
      fluent.withPowervs(instance.getPowervs());
      fluent.withVsphere(instance.getVsphere());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public MachinePoolPlatformBuilder(MachinePoolPlatform instance) {
    this(instance,false);
  }
  public MachinePoolPlatformBuilder(MachinePoolPlatform instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new MachinePoolPlatform());

    if (instance != null) {
      this.withAlibabacloud(instance.getAlibabacloud());
      this.withAws(instance.getAws());
      this.withAzure(instance.getAzure());
      this.withBaremetal(instance.getBaremetal());
      this.withGcp(instance.getGcp());
      this.withIbmcloud(instance.getIbmcloud());
      this.withLibvirt(instance.getLibvirt());
      this.withNutanix(instance.getNutanix());
      this.withOpenstack(instance.getOpenstack());
      this.withOvirt(instance.getOvirt());
      this.withPowervs(instance.getPowervs());
      this.withVsphere(instance.getVsphere());
      this.withAlibabacloud(instance.getAlibabacloud());
      this.withAws(instance.getAws());
      this.withAzure(instance.getAzure());
      this.withBaremetal(instance.getBaremetal());
      this.withGcp(instance.getGcp());
      this.withIbmcloud(instance.getIbmcloud());
      this.withLibvirt(instance.getLibvirt());
      this.withNutanix(instance.getNutanix());
      this.withOpenstack(instance.getOpenstack());
      this.withOvirt(instance.getOvirt());
      this.withPowervs(instance.getPowervs());
      this.withVsphere(instance.getVsphere());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  MachinePoolPlatformFluent<?> fluent;
  Boolean validationEnabled;
  public MachinePoolPlatform build() {
    MachinePoolPlatform buildable = new MachinePoolPlatform(fluent.buildAlibabacloud(),fluent.buildAws(),fluent.buildAzure(),fluent.buildBaremetal(),fluent.buildGcp(),fluent.buildIbmcloud(),fluent.buildLibvirt(),fluent.buildNutanix(),fluent.buildOpenstack(),fluent.buildOvirt(),fluent.buildPowervs(),fluent.buildVsphere());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}